<?php
/**
 * Tema WP Prestasi, tema CMS WordPress untuk website sekolah
 * Author : Ciuss Creative
 * Facebook : http://facebook.com/ciussgw
 * Whatsapp : 0815-3274-4804
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<?php preload_web_font_prestasi(); ?>
		<title><?php is_front_page() ? bloginfo('name') : wp_title(''); ?></title>
		
		<?php 
		    head_meta_property_prestasi();
			wp_head();
		?>
	
	<!-- Tema Prestasi dari ciuss.com rilis April 2021 -->

	</head>
	
	<body <?php body_class(); ?>>
	    <div class="prestasi">
		    
		    <section class="header clear">
			
			    <div class="press_top">
				    <div class="press_today">
					    <span><?php echo date_i18n('l, d M Y',time()); ?></span>
					</div>
					<div class="running">
				        <ul id="pressnews" class="newstickers">
				            <?php running_text_prestasi(); ?>
				    	</ul>
					</div>
					<?php get_search_form(); ?>
				</div>
				
				<div class="press_head">
				
				    <div class="head_area clear">
				        <div class="press_logo">
					    	<?php custom_logo_prestasi(); ?>
						</div>
						<div id="site-header-menu" class="site-header-menu press_nav">
						    <span class="closemenu">TUTUP MENU</span>
						    <?php 
							    if (has_nav_menu('navigation')) {
							    	wp_nav_menu(array(
									    'theme_location' => 'navigation', 
										'container' => 'div', 
										'container_class' => 'nav', 
										'menu_class' => 'dd desktop deskmenu', 
										'menu_id' => 'dd', 
										'fallback_cb' => false
										)
									);
								} else {
									echo '<div class="nav">
									        <ul id="dd" class="dd desktop deskmenu">
											    <li id="menu-item-319" class="menu-item">
												    <a target="_blank" href="'. esc_url( 'https://wpnubie.com/menampilkan-menu-menu-pada-header-web/' ) .'">Buat Menu</a>
												</li>
											</ul>
										</div>';
								}
							?>
						</div>
						<span class="botsearch"><i class="fa fa-search"></i></span>
		                <span class="botmenu"><i class="fa fa-navicon"></i></span>
					</div>
					
				</div>
				
			</section>
			
			<?php prestasi_home_slider(); ?>
			
			<!-- Content -->
			<div class="press_content clear">