<?php

function prestasi_press_color1_css() {
	$color_scheme          = prestasi_get_color_scheme();
	$default_color         = $color_scheme[1];
	$press_color1 = get_theme_mod( 'press_color1', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color1 === $default_color ) {
		return;
	}

	$css = '
	.prestasi {
		background: %1$s;
	}
	.press_cat a {
		color: %1$s;
	}
	.loop_meta span {
		color: %1$s;
	}
	.press_eventmonth,
	.press_eventdate {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color1 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color1_css', 11 );

function prestasi_press_color2_css() {
	$color_scheme  = prestasi_get_color_scheme();
	$default_color = $color_scheme[2];
	$press_color2  = get_theme_mod( 'press_color2', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color2 === $default_color ) {
		return;
	}

	$css = '
	.prestasi {
	    color: %1$s;
	}
	.loop_meta span {
		background: %1$s;
	}
	.press_eventmonth {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color2 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color2_css', 11 );

function prestasi_press_color3_css() {
	$color_scheme    = prestasi_get_color_scheme();
	$default_color   = $color_scheme[3];
	$press_color3 = get_theme_mod( 'press_color3', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color3 === $default_color ) {
		return;
	}

	$css = '
	.prestasi a {
	    color: %1$s;
	}
	.press_cat a {
		background: %1$s;
	}
	.press_tags a {
		border: 2px solid %1$s;
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color3) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color3_css', 11 );

function prestasi_press_run_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[4];
	$press_color4 = get_theme_mod( 'press_color4', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color4 === $default_color ) {
		return;
	}

	$css = '
		.press_top {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color4 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_run_bg_css', 11 );

function prestasi_press_run_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[5];
	$press_color5 = get_theme_mod( 'press_color5', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color5 === $default_color ) {
		return;
	}

	$css = '
		.press_top {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color5 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_run_text_css', 11 );

function prestasi_press_run_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[6];
	$press_color6 = get_theme_mod( 'press_color6', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color6 === $default_color ) {
		return;
	}

	$css = '
		.press_top a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color6 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_run_link_css', 11 );

function prestasi_press_menu_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[7];
	$press_color7 = get_theme_mod( 'press_color7', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color7 === $default_color ) {
		return;
	}

	$css = '
		.press_search,
		.ps_input input,
		.opensearch .press_search {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color7 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_menu_bg_css', 11 );

function prestasi_press_menu_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[8];
	$press_color8 = get_theme_mod( 'press_color8', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color8 === $default_color ) {
		return;
	}

	$css = '
		.press_search,
		.ps_input input,
		.opensearch .ps_input input, 
		.opensearch .ps_select select {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color8 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_menu_text_css', 11 );

function prestasi_press_menu_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[9];
	$press_color9 = get_theme_mod( 'press_color9', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color9 === $default_color ) {
		return;
	}

	$css = '
		.ps_button button,
		.botclose {
            background: %1$s;
        }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color9 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_menu_link_css', 11 );

function prestasi_press_sub_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[10];
	$press_color10 = get_theme_mod( 'press_color10', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color10 === $default_color ) {
		return;
	}

	$css = '
		.ps_button button,
		.botclose {
	    	color: %1$s;
        }   
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color10 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sub_bg_css', 11 );


function prestasi_press_sub_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[11];
	$press_color11 = get_theme_mod( 'press_color11', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color11 === $default_color ) {
		return;
	}

	$css = '
		.press_head:after,
		.nav .dd.desktop li ul {
	    	background : %1$s;
    	}
		.closemenu {
	    	color : %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color11 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sub_link_css', 11 );

function prestasi_press_phone_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[12];
	$press_color12 = get_theme_mod( 'press_color12', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color12 === $default_color ) {
		return;
	}

	$css = '
		.nav .dd.desktop li a,
		.nav .dd.desktop li.menu-item-has-children:after,
		.nav li a,
    	.nav li.has-sub.active:after,
        .nav li.has-sub:after,
		.nav .dd.accord li.menu-item-has-children:after {
			color: %1$s;
		}
		.closemenu {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color12 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_phone_bg_css', 11 );

function prestasi_press_phone_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[13];
	$press_color13 = get_theme_mod( 'press_color13', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color13 === $default_color ) {
		return;
	}

	$css = '
		.botsearch {
		background: %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color13 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_phone_text_css', 11 );

function prestasi_press_phone_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[14];
	$press_color14 = get_theme_mod( 'press_color14', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color14 === $default_color ) {
		return;
	}

	$css = '
		.botsearch {
		color: %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color14 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_phone_link_css', 11 );

function prestasi_press_event_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[15];
	$press_color15 = get_theme_mod( 'press_color15', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color15 === $default_color ) {
		return;
	}

	$css = '
		.botsearch {
		border: 2px solid %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color15 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_event_bg_css', 11 );

function prestasi_press_event_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[16];
	$press_color16 = get_theme_mod( 'press_color16', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color16 === $default_color ) {
		return;
	}

	$css = '
		.botmenu {
		background: %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color16 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_event_text_css', 11 );

function prestasi_press_event_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[17];
	$press_color17 = get_theme_mod( 'press_color17', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color17 === $default_color ) {
		return;
	}

	$css = '
		.botmenu {
		color: %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color17 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_event_link_css', 11 );

function prestasi_press_list_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[18];
	$press_color18 = get_theme_mod( 'press_color18', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color18 === $default_color ) {
		return;
	}

	$css = '
		.botmenu {
		border: 2px solid %1$s;
    	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color18 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_list_bg_css', 11 );

function prestasi_press_list_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[19];
	$press_color19 = get_theme_mod( 'press_color19', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color19 === $default_color ) {
		return;
	}

	$css = '
		@media screen and (max-width: 800px) {
    	.press_nav {
	    	background : %1$s;
    	}
		.closemenu {
	    	color: %1$s;
	    }
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color19 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_list_text_css', 11 );

function prestasi_press_list_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[20];
	$press_color20 = get_theme_mod( 'press_color20', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color20 === $default_color ) {
		return;
	}

	$css = '
    	.nav .dd.accord li a,
     	.nav .dd.accord li.has-sub.active:after,
        .nav .dd.accord li.has-sub:after,
    	.nav .dd.accord li.menu-item-has-children:after {
	    	color : %1$s;
    	}
		.closemenu {
	    	background: %1$s;
	    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color20 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_list_link_css', 11 );

function prestasi_press_pro_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[21];
	$press_color21 = get_theme_mod( 'press_color21', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color21 === $default_color ) {
		return;
	}

	$css = '
		#fourblock {
			background: #fff;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color21 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_pro_bg_css', 11 );

function prestasi_press_pro_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[22];
	$press_color22 = get_theme_mod( 'press_color22', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color22 === $default_color ) {
		return;
	}

	$css = '
		.press_infosekolah {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color22 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_pro_text_css', 11 );

function prestasi_press_pro_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[23];
	$press_color23 = get_theme_mod( 'press_color23', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color23 === $default_color ) {
		return;
	}

	$css = '
		.press_infosekolah:after {
			background: %1$s;
		}
		.con_box .phone {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color23 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_pro_link_css', 11 );

function prestasi_press_pri_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[24];
	$press_color24 = get_theme_mod( 'press_color24', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color24 === $default_color ) {
		return;
	}

	$css = '
		.info_box h3 span.re_info {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color24 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_pri_text_css', 11 );

function prestasi_press_color25_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[25];
	$press_color25 = get_theme_mod( 'press_color25', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color25 === $default_color ) {
		return;
	}

	$css = '
		.info_box h3 span.re_info {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color25 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color25_css', 11 );

function prestasi_press_color26_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[26];
	$press_color26 = get_theme_mod( 'press_color26', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color26 === $default_color ) {
		return;
	}

	$css = '
		.info_box h3 span.re_info {
			border: 2px solid %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color26 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color26_css', 11 );

function prestasi_press_color27_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[27];
	$press_color27 = get_theme_mod( 'press_color27', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color27 === $default_color ) {
		return;
	}

	$css = '
		.info_box h1 {
			color: %1$s;
		}
		.info_box h1:after,
		.school_box:after {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color27 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_color27_css', 11 );

function prestasi_press_box_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[28];
	$press_color28 = get_theme_mod( 'press_color28', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color28 === $default_color ) {
		return;
	}

	$css = '
		.info_tab {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color28 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_box_bg_css', 11 );

function prestasi_press_box_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[29];
	$press_color29 = get_theme_mod( 'press_color29', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color29 === $default_color ) {
		return;
	}

	$css = '
		.con_box .ks,
		.con_box .phone a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color29 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_box_text_css', 11 );

function prestasi_press_box_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[30];
	$press_color30 = get_theme_mod( 'press_color30', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color30 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-facebook {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color30 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_box_link_css', 11 );

function prestasi_press_label_limited_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[31];
	$press_color31 = get_theme_mod( 'press_color31', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color31 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-facebook {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color31 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_label_limited_css', 11 );

function prestasi_press_label_indent_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[32];
	$press_color32 = get_theme_mod( 'press_color32', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color32 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-twitter {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color32 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_label_indent_css', 11 );

function prestasi_press_label_populer_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[33];
	$press_color33 = get_theme_mod( 'press_color33', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color33 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-twitter {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color33 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_label_populer_css', 11 );

function prestasi_press_label_promo_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[34];
	$press_color34 = get_theme_mod( 'press_color34', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color34 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-instagram {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color34 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_label_promo_css', 11 );

function prestasi_press_label_best_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[35];
	$press_color35 = get_theme_mod( 'press_color35', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color35 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-instagram {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color35 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_label_best_css', 11 );

function prestasi_press_par_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[36];
	$press_color36 = get_theme_mod( 'press_color36', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color36 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-youtube {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color36 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_par_bg_css', 11 );

function prestasi_press_par_nama_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[37];
	$press_color37 = get_theme_mod( 'press_color37', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color37 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-youtube {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color37 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_par_nama_css', 11 );

function prestasi_press_par_bio_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[38];
	$press_color38 = get_theme_mod( 'press_color38', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color38 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-envelope-o {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color38 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_par_bio_css', 11 );

function prestasi_press_tes_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[39];
	$press_color39 = get_theme_mod( 'press_color39', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color39 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-envelope-o {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color39 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tes_bg_css', 11 );

function prestasi_press_tes_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[40];
	$press_color40 = get_theme_mod( 'press_color40', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color40 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-whatsapp {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color40 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tes_text_css', 11 );

function prestasi_press_tes_rate_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[41];
	$press_color41 = get_theme_mod( 'press_color41', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color41 === $default_color ) {
		return;
	}

	$css = '
		.press_social .fa-whatsapp {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color41 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tes_rate_css', 11 );

function prestasi_press_add_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[42];
	$press_color42 = get_theme_mod( 'press_color42', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color42 === $default_color ) {
		return;
	}

	$css = '
	    .home_agenda,
		.home_agenda:after {
			background-color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color42 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_add_bg_css', 11 );

function prestasi_press_add_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[43];
	$press_color43 = get_theme_mod( 'press_color43', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color43 === $default_color ) {
		return;
	}

	$css = '
		.home_agenda  {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color43 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_add_text_css', 11 );

function prestasi_press_add_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[44];
	$press_color44 = get_theme_mod( 'press_color44', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color44 === $default_color ) {
		return;
	}

	$css = '
		.table_agenda .span,
		.foot_agenda a {
			color: %1$s;
		}
		.foot_agenda a:after {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color44 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_add_link_css', 11 );

function prestasi_press_gal_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[45];
	$press_color45 = get_theme_mod( 'press_color45', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color45 === $default_color ) {
		return;
	}

	$css = '
	    .latest_agenda h4 a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color45 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gal_bg_css', 11 );

function prestasi_press_gal_hd_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[46];
	$press_color46 = get_theme_mod( 'press_color46', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color46 === $default_color ) {
		return;
	}

	$css = '
	.near_agenda h3 span.re_agenda {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color46 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gal_hd_css', 11 );

function prestasi_press_gal_hdtext_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[47];
	$press_color47 = get_theme_mod( 'press_color47', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color47 === $default_color ) {
		return;
	}

	$css = '
	.near_agenda h3 span.re_agenda {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color47 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gal_hdtext_css', 11 );

function prestasi_press_gall_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[48];
	$press_color48 = get_theme_mod( 'press_color48', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color48 === $default_color ) {
		return;
	}

	$css = '
	.near_agenda h3 span.re_agenda {
		border: %1$s solid 2px;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color48 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gall_bg_css', 11 );

function prestasi_press_gall_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[49];
	$press_color49 = get_theme_mod( 'press_color49', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color49 === $default_color ) {
		return;
	}

	$css = '
		.post_meta {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color49 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gall_text_css', 11 );

function prestasi_press_maps_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[50];
	$press_color50 = get_theme_mod( 'press_color50', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color50 === $default_color ) {
		return;
	}

	$css = '
	.post_meta,
	.post_meta a {
		color: %1$s;
	}
	.post_meta span {
		color: %1$s;
		border: %1$s solid 2px;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color50 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_maps_bg_css', 11 );

function prestasi_press_off_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[51];
	$press_color51 = get_theme_mod( 'press_color51', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color51 === $default_color ) {
		return;
	}

	$css = '
		.announ_home {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color51 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_off_bg_css', 11 );

function prestasi_press_off_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[52];
	$press_color52 = get_theme_mod( 'press_color52', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color52 === $default_color ) {
		return;
	}

	$css = '
		.announ_home {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color52 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_off_text_css', 11 );

function prestasi_press_text_aksen_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[53];
	$press_color53 = get_theme_mod( 'press_color53', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color53 === $default_color ) {
		return;
	}

	$css = '
		.announ_home a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color53 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_text_aksen_css', 11 );

function prestasi_press_sing_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[54];
	$press_color54 = get_theme_mod( 'press_color54', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color54 === $default_color ) {
		return;
	}

	$css = '
		.announ_post h3 span.re_announ {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color54 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sing_bg_css', 11 );

function prestasi_press_sing_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[55];
	$press_color55 = get_theme_mod( 'press_color55', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color55 === $default_color ) {
		return;
	}

	$css = '
		.announ_post h3 span.re_announ {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color55 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sing_text_css', 11 );

function prestasi_press_sing_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[56];
	$press_color56 = get_theme_mod( 'press_color56', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color56 === $default_color ) {
		return;
	}

	$css = '
		.announ_post h3 span.re_announ {
			border: 2px solid %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color56 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sing_link_css', 11 );

function prestasi_press_form_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[57];
	$press_color57 = get_theme_mod( 'press_color57', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color57 === $default_color ) {
		return;
	}

	$css = '
    .press_boxquote {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color57 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_form_bg_css', 11 );

function prestasi_press_form_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[58];
	$press_color58 = get_theme_mod( 'press_color58', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color58 === $default_color ) {
		return;
	}

	$css = '
	.press_boxquote {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color58 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_form_text_css', 11 );

function prestasi_press_but_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[59];
	$press_color59 = get_theme_mod( 'press_color59', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color59 === $default_color ) {
		return;
	}

	$css = '
	.press_boxquote h4,
	.quotes_acc {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color59 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_but_bg_css', 11 );

function prestasi_press_but_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[60];
	$press_color60 = get_theme_mod( 'press_color60', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color60 === $default_color ) {
		return;
	}

	$css = '
		#personelblock {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color60 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_but_text_css', 11 );

function prestasi_press_sid_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[61];
	$press_color61 = get_theme_mod( 'press_color61', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color61 === $default_color ) {
		return;
	}

	$css = '
		.head_datas {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color61 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sid_bg_css', 11 );

function prestasi_press_sid_hd_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[62];
	$press_color62 = get_theme_mod( 'press_color62', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color62 === $default_color ) {
		return;
	}

	$css = '
		.head_datas {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color62 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sid_hd_css', 11 );

function prestasi_press_sid_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[63];
	$press_color63 = get_theme_mod( 'press_color63', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color63 === $default_color ) {
		return;
	}

	$css = '
		.editorial_more a {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color63 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sid_text_css', 11 );

function prestasi_press_sid_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[64];
	$press_color64 = get_theme_mod( 'press_color64', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color64 === $default_color ) {
		return;
	}

	$css = '
		.editorial_more a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color64 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sid_link_css', 11 );

function prestasi_press_sidtag_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[65];
	$press_color65 = get_theme_mod( 'press_color65', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color65 === $default_color ) {
		return;
	}

	$css = '
		.editorial_more a {
			border: 2px solid %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color65 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sidtag_bg_css', 11 );

function prestasi_press_sidtag_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[66];
	$press_color66 = get_theme_mod( 'press_color66', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color66 === $default_color ) {
		return;
	}

	$css = '
		.person .item {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color66 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_sidtag_text_css', 11 );

function prestasi_press_foo_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[67];
	$press_color67 = get_theme_mod( 'press_color67', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color67 === $default_color ) {
		return;
	}

	$css = '
		.person .item {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color67 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foo_bg_css', 11 );

function prestasi_press_foo_hd_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[68];
	$press_color68 = get_theme_mod( 'press_color68', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color68 === $default_color ) {
		return;
	}

	$css = '
		.person .item a {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color68 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foo_hd_css', 11 );

function prestasi_press_foo_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[69];
	$press_color69 = get_theme_mod( 'press_color69', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color69 === $default_color ) {
		return;
	}

	$css = '
		#anotherblock {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color69 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foo_text_css', 11 );

function prestasi_press_foo_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[70];
	$press_color70 = get_theme_mod( 'press_color70', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color70 === $default_color ) {
		return;
	}

	$css = '
    .blog_box h3 span.re_blog {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color70 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foo_link_css', 11 );

function prestasi_press_footag_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[71];
	$press_color71 = get_theme_mod( 'press_color71', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color71 === $default_color ) {
		return;
	}

	$css = '
	.blog_box h3 span.re_blog {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color71 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_footag_bg_css', 11 );

function prestasi_press_footag_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[72];
	$press_color72 = get_theme_mod( 'press_color72', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color72 === $default_color ) {
		return;
	}

	$css = '
	.blog_box h3 span.re_blog {
		border: %1$s solid 2px;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color72 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_footag_text_css', 11 );

function prestasi_press_copy_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[73];
	$press_color73 = get_theme_mod( 'press_color73', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color73 === $default_color ) {
		return;
	}

	$css = '
		.blog_in {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color73 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copy_bg_css', 11 );

function prestasi_press_copy_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[74];
	$press_color74 = get_theme_mod( 'press_color74', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color74 === $default_color ) {
		return;
	}

	$css = '
		.meta_in {
			color: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color74 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copy_text_css', 11 );

function prestasi_press_copy_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[75];
	$press_color75 = get_theme_mod( 'press_color75', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color75 === $default_color ) {
		return;
	}

	$css = '
		.blog_in h4 a {
			color: %1$s;
		}
		.meta_in:after {
			background: %1$s;
		}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color75 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copy_link_css', 11 );

function prestasi_press_mob_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[76];
	$press_color76 = get_theme_mod( 'press_color76', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color76 === $default_color ) {
		return;
	}

	$css = '
		.home_fasilitas {
		    color: %1$s;
        }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color76 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_mob_bg_css', 11 );

function prestasi_press_mob_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[77];
	$press_color77 = get_theme_mod( 'press_color77', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color77 === $default_color ) {
		return;
	}

	$css = '
	.home_extra {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color77 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_mob_link_css', 11 );

function prestasi_press_keg_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[78];
	$press_color78 = get_theme_mod( 'press_color78', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color78 === $default_color ) {
		return;
	}

	$css = '
	.box_extra {
		 background: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color78 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_keg_bg_css', 11 );

function prestasi_press_keg_color_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[79];
	$press_color79 = get_theme_mod( 'press_color79', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color79 === $default_color ) {
		return;
	}

	$css = '
	.box_extra,
	.extra_text h5 {
		 color: %1$s;
    }
	.extra_text span.re_lihat {
		color: %1$s;
		border: 2px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color79 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_keg_color_css', 11 );

function prestasi_press_gal_head_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[80];
	$press_color80 = get_theme_mod( 'press_color80', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color80 === $default_color ) {
		return;
	}

	$css = '
	.home_gall {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color80 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gal_head_css', 11 );

function prestasi_press_vid_head_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[81];
	$press_color81 = get_theme_mod( 'press_color81', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color81 === $default_color ) {
		return;
	}

	$css = '
	.home_video {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color81 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_vid_head_css', 11 );

function prestasi_press_bg_head_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[82];
	$press_color82 = get_theme_mod( 'press_color82', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color82 === $default_color ) {
		return;
	}

	$css = '
	.press_page:after {
		 background: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color82 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_bg_head_css', 11 );

function prestasi_press_col_head_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[83];
	$press_color83 = get_theme_mod( 'press_color83', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color83 === $default_color ) {
		return;
	}

	$css = '
	.press_page h1 {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color83 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_col_head_css', 11 );

function prestasi_press_arsip_head_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[84];
	$press_color84 = get_theme_mod( 'press_color84', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color84 === $default_color ) {
		return;
	}

	$css = '
	.post_in h2 a {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color84 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_arsip_head_css', 11 );

function prestasi_press_tang_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[85];
	$press_color85 = get_theme_mod( 'press_color85', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color85 === $default_color ) {
		return;
	}

	$css = '
	.post_inpublish {
		 background: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color85 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tang_bg_css', 11 );

function prestasi_press_tang_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[86];
	$press_color86 = get_theme_mod( 'press_color86', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color86 === $default_color ) {
		return;
	}

	$css = '
	.post_inpublish {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color86 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tang_col_css', 11 );

function prestasi_press_lewat_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[87];
	$press_color87 = get_theme_mod( 'press_color87', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color87 === $default_color ) {
		return;
	}

	$css = '
	.post_inpublish.expired {
		 background: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color87 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_lewat_bg_css', 11 );

function prestasi_press_lewat_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[88];
	$press_color88 = get_theme_mod( 'press_color88', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color88 === $default_color ) {
		return;
	}

	$css = '
	.post_inpublish.expired {
		 color: %1$s;
    }
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color88 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_lewat_col_css', 11 );

function prestasi_press_gtk_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[89];
	$press_color89 = get_theme_mod( 'press_color89', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color89 === $default_color ) {
		return;
	}

	$css = '
	.post-type-archive-gtk .post_in {
		 background: %1$s;
    }
	.prestasi a.jab {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color89 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_lewat_bg_css', 11 );

function prestasi_press_gtk_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[90];
	$press_color90 = get_theme_mod( 'press_color90', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color90 === $default_color ) {
		return;
	}

	$css = '
	.prestasi a.guru_fullname {
		 color: %1$s;
    }
	.prestasi a.jab {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color90 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_gtk_col_css', 11 );

function prestasi_press_tr_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[91];
	$press_color91 = get_theme_mod( 'press_color91', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color91 === $default_color ) {
		return;
	}

	$css = '
	.press_tab tr.top_tab,
	.some_input,
	.some_cat span {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color91 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tr_bg_css', 11 );

function prestasi_press_tr_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[92];
	$press_color92 = get_theme_mod( 'press_color92', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color92 === $default_color ) {
		return;
	}

	$css = '
	.press_tab tr.top_tab,
	.some_input,
	.some_cat span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color92 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_tr_col_css', 11 );

function prestasi_press_table_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[93];
	$press_color93 = get_theme_mod( 'press_color93', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color93 === $default_color ) {
		return;
	}

	$css = '
	.press_tab {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color93 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_table_col_css', 11 );

function prestasi_press_table_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[94];
	$press_color94 = get_theme_mod( 'press_color94', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color94 === $default_color ) {
		return;
	}

	$css = '
	.press_tab a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color94 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_table_link_css', 11 );

function prestasi_press_materi_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[95];
	$press_color95 = get_theme_mod( 'press_color95', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color95 === $default_color ) {
		return;
	}

	$css = '
	.post-type-archive-materi #listing {
		background: %1$s;
	}
	.kelas_head .to_materi {
		color: %1$s;
	}
	.post-type-archive-materi #listing a.login_button,
	.post-type-archive-materi #listing a.logout_button,
	.single-materi #listing a.login_button,
	.single-materi #listing a.logout_button,
	.oc_class span:after,
	.oc_class span:before {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color95 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_materi_bg_css', 11 );

function prestasi_press_materi_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[96];
	$press_color96 = get_theme_mod( 'press_color96', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color96 === $default_color ) {
		return;
	}

	$css = '
	.post-type-archive-materi #listing,
	.ajax-auth h3 {
		color: %1$s;
	}
	.kelas_head .to_materi {
		background: %1$s;
	}
	.post-type-archive-materi #listing a.login_button,
	.single-materi #listing a.login_button,
	.oc_class span:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color96 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_materi_col_css', 11 );

function prestasi_press_materi_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[97];
	$press_color97 = get_theme_mod( 'press_color97', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color97 === $default_color ) {
		return;
	}

	$css = '
	.post-type-archive-materi #listing a {
		color: %1$s;
	}
	.post-type-archive-materi #listing a.logout_button,
	.single-materi #listing a.logout_button,
	.oc_class span:before {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color97 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_materi_link_css', 11 );

function prestasi_press_soal_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[98];
	$press_color98 = get_theme_mod( 'press_color98', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color98 === $default_color ) {
		return;
	}

	$css = '
	.materi_box,
    .tugas_term,
	.tugas_term:after,
	.log_open,
	.inform ,
	.ajax-auth input#username,
    .ajax-auth input#password,
    .ajax-auth input#signonname,
    .ajax-auth input#email,
    .ajax-auth input#signonpassword,
    .ajax-auth input#password2 {
		background: %1$s;
	}
	.tugas_term span {
		color: %1$s;
	}
	.ajax-auth input.submit_button {
		color: %1$s;
	}
	.post-type-archive-materi #listing a.det_mapel {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color98 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_soal_bg_css', 11 );

function prestasi_press_soal_border_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[99];
	$press_color99 = get_theme_mod( 'press_color99', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color99 === $default_color ) {
		return;
	}

	$css = '
	.materi_box,
	.tugas_term,
	.log_open,
	.ajax-auth input#username,
    .ajax-auth input#password,
    .ajax-auth input#signonname,
    .ajax-auth input#email,
    .ajax-auth input#signonpassword,
    .ajax-auth input#password2 {
		border: 1px solid %1$s;
	}
	.tugas_term:before {
		background: %1$s;
	}
	.soal_kumpulan {
		border-top: 1px solid %1$s;
	}
	.soal_box {
		border-bottom: 1px solid %1$s;
	}
	.post-type-archive-materi #listing a.det_mapel,
	.post-type-archive-materi #listing a.det_kelas {
		background: %1$s;
	}
	.per_materi {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color99 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_soal_border_css', 11 );

function prestasi_press_soal_text_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[100];
	$press_color100 = get_theme_mod( 'press_color100', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color100 === $default_color ) {
		return;
	}

	$css = '
	.materi_box {
		color: %1$s;
	}
	.tugas_term span {
		background: %1$s;
	}
	.per_materi {
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color100 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_soal_text_css', 11 );

function prestasi_press_soal_link_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[101];
	$press_color101 = get_theme_mod( 'press_color101', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color101 === $default_color ) {
		return;
	}

	$css = '
	.stat_col,
	.post-type-archive-materi #listing .tugas_term a,
    .post-type-archive-materi #listing .det_materi h4 a,
	.post-type-archive-materi #listing .forg a {
		color: %1$s;
	}
	.ajax-auth input.submit_button {
		background: %1$s;
	}
	.post-type-archive-materi #listing a.det_kelas {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color101 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_soal_link_css', 11 );

function prestasi_press_countdown_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[102];
	$press_color102 = get_theme_mod( 'press_color102', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color102 === $default_color ) {
		return;
	}

	$css = '
	.event_active,
	.meta_active {
		color: %1$s;
	}
	.press_eventdate {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color102 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_countdown_css', 11 );

function prestasi_press_expired_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[103];
	$press_color103 = get_theme_mod( 'press_color103', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color103 === $default_color ) {
		return;
	}

	$css = '
	.event_expired,
	.meta_expired {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color103 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_expired_css', 11 );

function prestasi_press_singbor_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[104];
	$press_color104 = get_theme_mod( 'press_color104', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color104 === $default_color ) {
		return;
	}

	$css = '
	.secondary_content {
		border-left: 1px solid %1$s;
	}
	.people .secondary_content {
		border-right: 1px solid %1$s;
	}
	.press_cat {
		border-left: 1px solid %1$s;
		border-right: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color104 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_singbor_css', 11 );

function prestasi_press_com_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[105];
	$press_color105 = get_theme_mod( 'press_color105', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color105 === $default_color ) {
		return;
	}

	$css = '
	#comment,
	#author,
	#email,
	#url {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color105 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_com_bg_css', 11 );

function prestasi_press_com_bor_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[106];
	$press_color106 = get_theme_mod( 'press_color106', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color106 === $default_color ) {
		return;
	}

	$css = '
	#comment,
	#author,
	#email,
	#url {
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color106 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_com_bor_css', 11 );

function prestasi_press_com_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[107];
	$press_color107 = get_theme_mod( 'press_color107', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color107 === $default_color ) {
		return;
	}

	$css = '
	#comment,
	#author,
	#email,
	#url {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color107 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_com_col_css', 11 );

function prestasi_press_submit_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[108];
	$press_color108 = get_theme_mod( 'press_color108', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color108 === $default_color ) {
		return;
	}

	$css = '
	#submit {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color108 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_submit_bg_css', 11 );

function prestasi_press_submit_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[109];
	$press_color109 = get_theme_mod( 'press_color109', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color109 === $default_color ) {
		return;
	}

	$css = '
	#submit {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color109 ) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_submit_col_css', 11 );

function prestasi_press_footbar_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[110];
	$press_color110 = get_theme_mod( 'press_color110', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color110 === $default_color ) {
		return;
	}

	$css = '
	#footerbar {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color110) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_footbar_css', 11 );

function prestasi_press_footcol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[111];
	$press_color111 = get_theme_mod( 'press_color111', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color111 === $default_color ) {
		return;
	}

	$css = '
	#footerbar {
		color: %1$s;
	}
	.wid_icon .fa {
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color111) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_footcol_css', 11 );

function prestasi_press_footlink_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[112];
	$press_color112 = get_theme_mod( 'press_color112', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color112 === $default_color ) {
		return;
	}

	$css = '
	.widget a {
		color: %1$s;
	}
	.widget h3 span {
		border-bottom: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color112) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_footlink_css', 11 );

function prestasi_press_foot_tag_bg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[112];
	$press_color113 = get_theme_mod( 'press_color113', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color113 === $default_color ) {
		return;
	}

	$css = '
	.widget .tagcloud a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color113) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foot_tag_bg_css', 11 );

function prestasi_press_foot_tag_col_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[114];
	$press_color114 = get_theme_mod( 'press_color114', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color114 === $default_color ) {
		return;
	}

	$css = '
	.widget .tagcloud a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color114) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_foot_tag_col_css', 11 );

function prestasi_press_copybg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[115];
	$press_color115 = get_theme_mod( 'press_color115', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color115 === $default_color ) {
		return;
	}

	$css = '
	.footer {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color115) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copybg_css', 11 );

function prestasi_press_copycol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[116];
	$press_color116 = get_theme_mod( 'press_color116', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color116 === $default_color ) {
		return;
	}

	$css = '
	.footer {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color116) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copycol_css', 11 );

function prestasi_press_copylink_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[117];
	$press_color117 = get_theme_mod( 'press_color117', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color117 === $default_color ) {
		return;
	}

	$css = '
	.footer a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color117) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_copylink_css', 11 );

function prestasi_press_homebg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[118];
	$press_color118 = get_theme_mod( 'press_color118', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color118 === $default_color ) {
		return;
	}

	$css = '
	.nhome {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color118) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_homebg_css', 11 );

function prestasi_press_homecol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[119];
	$press_color119 = get_theme_mod( 'press_color119', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color119 === $default_color ) {
		return;
	}

	$css = '
	.nhome {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color119) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_homecol_css', 11 );

function prestasi_press_phonebg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[120];
	$press_color120 = get_theme_mod( 'press_color120', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color120 === $default_color ) {
		return;
	}

	$css = '
	.nphone {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color120) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_phonebg_css', 11 );

function prestasi_press_phonecol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[121];
	$press_color121 = get_theme_mod( 'press_color121', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color121 === $default_color ) {
		return;
	}

	$css = '
	.nphone {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color121) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_phonecol_css', 11 );

function prestasi_press_emailbg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[122];
	$press_color122 = get_theme_mod( 'press_color122', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color122 === $default_color ) {
		return;
	}

	$css = '
	.nemail {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color122) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_emailbg_css', 11 );

function prestasi_press_emailcol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[123];
	$press_color123 = get_theme_mod( 'press_color123', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color123 === $default_color ) {
		return;
	}

	$css = '
	.nemail {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color123) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_emailcol_css', 11 );

function prestasi_press_wabg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[124];
	$press_color124 = get_theme_mod( 'press_color124', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color124 === $default_color ) {
		return;
	}

	$css = '
	.nwa {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color124) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_wabg_css', 11 );

function prestasi_press_wacol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[125];
	$press_color125 = get_theme_mod( 'press_color125', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color125 === $default_color ) {
		return;
	}

	$css = '
	.nwa {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color125) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_wacol_css', 11 );

function prestasi_press_srollbg_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[126];
	$press_color126 = get_theme_mod( 'press_color126', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color126 === $default_color ) {
		return;
	}

	$css = '
	.nscroll {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color126) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_srollbg_css', 11 );

function prestasi_press_srollcol_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[127];
	$press_color127 = get_theme_mod( 'press_color127', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color127 === $default_color ) {
		return;
	}

	$css = '
	.nscroll {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color127) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_srollcol_css', 11 );

function prestasi_press_presstab_css() {
	$color_scheme         = prestasi_get_color_scheme();
	$default_color        = $color_scheme[128];
	$press_color128 = get_theme_mod( 'press_color128', $default_color );

	// Don't do anything if the current color is the default.
	if ( $press_color128 === $default_color ) {
		return;
	}

	$css = '
	.press_tab tr,
	.some_cat,
	.some_result {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'press-style', sprintf( $css, $press_color128) );
}
add_action( 'wp_enqueue_scripts', 'prestasi_press_presstab_css', 11 );
