<?php
function prestasi_wp_customize_register( $wp_customize ) {
	$color_scheme = prestasi_get_color_scheme();
    
	// Add color scheme setting and control.
	$wp_customize->add_setting(
		'color_scheme',
		array(
			'default'           => 'default',
			'sanitize_callback' => 'prestasi_sanitize_color_scheme',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'color_scheme',
		array(
			'label'    => __( 'Pilihan Warna Tema', 'prestasi' ),
			'section'  => 'colors',
			'type'     => 'select',
			'choices'  => prestasi_get_color_scheme_choices(),
			'priority' => 1,
		)
	);

	// Add page background color setting and control.
	$wp_customize->add_setting(
		'press_color1',
		array(
			'default'           => $color_scheme[1],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color1',
			array(
				'label'   => __( 'Background Wrapper', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);

	// Remove the core header press_color3 control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Add link color setting and control.
	$wp_customize->add_setting(
		'press_color2',
		array(
			'default'           => $color_scheme[2],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color2',
			array(
				'label'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);

	// Add main text color setting and control.
	$wp_customize->add_setting(
		'press_color3',
		array(
			'default'           => $color_scheme[3],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
    
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color3',
			array(
				'label'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);

	// Running Text.
	$wp_customize->add_setting(
		'press_color4',
		array(
			'default'           => $color_scheme[4],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color4',
			array(
			    'label'             => __( 'Text Berjalan', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color5',
		array(
			'default'           => $color_scheme[5],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color5',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color6',
		array(
			'default'           => $color_scheme[6],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color6',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color7',
		array(
			'default'           => $color_scheme[7],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color7',
			array(
				'label'   => __( 'Search Header', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color8',
		array(
			'default'           => $color_scheme[8],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color8',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color9',
		array(
			'default'           => $color_scheme[9],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color9',
			array(
				'description'   => __( 'Button BG', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color10',
		array(
			'default'           => $color_scheme[10],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color10',
			array(
				'description'   => __( 'Button Text', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color11',
		array(
			'default'           => $color_scheme[11],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color11',
			array(
				'label'   => __( 'Header', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Phone Header
	$wp_customize->add_setting(
		'press_color12',
		array(
			'default'           => $color_scheme[12],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color12',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color13',
		array(
			'default'           => $color_scheme[13],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color13',
			array(
			    'label'   => __( 'Ikon Search Mobile', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color14',
		array(
			'default'           => $color_scheme[14],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color14',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Agenda Home
	$wp_customize->add_setting(
		'press_color15',
		array(
			'default'           => $color_scheme[15],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color15',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color16',
		array(
			'default'           => $color_scheme[16],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color16',
			array(
				'label'   => __( 'Ikon Menu Mobile', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color17',
		array(
			'default'           => $color_scheme[17],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color17',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Listing Home
	$wp_customize->add_setting(
		'press_color18',
		array(
			'default'           => $color_scheme[18],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color18',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color19',
		array(
			'default'           => $color_scheme[19],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color19',
			array(
				'label'   => __( 'Menu Mobile', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color20',
		array(
			'default'           => $color_scheme[20],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color20',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Produk
	$wp_customize->add_setting(
		'press_color21',
		array(
			'default'           => $color_scheme[21],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color21',
			array(
				'label'   => __( 'After Slider', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color22',
		array(
			'default'           => $color_scheme[22],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color22',
			array(
			    'label'   => __( 'Info Sekolah', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color23',
		array(
			'default'           => $color_scheme[23],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color23',
			array(
				'description'   => __( 'Aksen Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color24',
		array(
			'default'           => $color_scheme[24],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color24',
			array(
			    'label'   => __( 'Span Title', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Agen
	$wp_customize->add_setting(
		'press_color25',
		array(
			'default'           => $color_scheme[25],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color25',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color26',
		array(
			'default'           => $color_scheme[26],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color26',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color27',
		array(
			'default'           => $color_scheme[27],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color27',
			array(
				'label'   => __( 'Nama Sekolah', 'prestasi' ),
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color28',
		array(
			'default'           => $color_scheme[28],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color28',
			array(
			    'label'   => __( 'Alamat Sekolah', 'prestasi' ),
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color29',
		array(
			'default'           => $color_scheme[29],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color29',
			array(
				'label'   => __( 'Telepon Sekolah', 'prestasi' ),
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color30',
		array(
			'default'           => $color_scheme[30],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color30',
			array(
			    'label'   => __( 'Facebook', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Label Kendaraan
	$wp_customize->add_setting(
		'press_color31',
		array(
			'default'           => $color_scheme[31],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color31',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color32',
		array(
			'default'           => $color_scheme[32],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color32',
			array(
			    'label'   => __( 'Twitter', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color33',
		array(
			'default'           => $color_scheme[33],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color33',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color34',
		array(
			'default'           => $color_scheme[34],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color34',
			array(
			    'label'   => __( 'Instagram', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color35',
		array(
			'default'           => $color_scheme[35],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color35',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Parallax
	$wp_customize->add_setting(
		'press_color36',
		array(
			'default'           => $color_scheme[36],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color36',
			array(
				'label'   => __( 'Youtube', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color37',
		array(
			'default'           => $color_scheme[37],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color37',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color38',
		array(
			'default'           => $color_scheme[38],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color38',
			array(
			    'label'   => __( 'Email', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color39',
		array(
			'default'           => $color_scheme[39],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color39',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color40',
		array(
			'default'           => $color_scheme[40],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color40',
			array(
				'label'   => __( 'Whatsapp', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color41',
		array(
			'default'           => $color_scheme[41],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color41',
			array(
				'description'   => __( 'Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Additional
	$wp_customize->add_setting(
		'press_color42',
		array(
			'default'           => $color_scheme[42],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color42',
			array(
				'label'   => __( 'Agenda Beranda', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color43',
		array(
			'default'           => $color_scheme[43],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color43',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color44',
		array(
			'default'           => $color_scheme[44],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color44',
			array(
				'description'   => __( 'Aksen Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Galeri
	$wp_customize->add_setting(
		'press_color45',
		array(
			'default'           => $color_scheme[45],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color45',
			array(
				'description'   => __( 'Title Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color46',
		array(
			'default'           => $color_scheme[46],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color46',
			array(
				'label'   => __( 'Span Title', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color47',
		array(
			'default'           => $color_scheme[47],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color47',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Galeri Box
	$wp_customize->add_setting(
		'press_color48',
		array(
			'default'           => $color_scheme[48],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color48',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color49',
		array(
			'default'           => $color_scheme[49],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color49',
			array(
			    'label' => __( 'Pos Slide', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Office Box
	$wp_customize->add_setting(
		'press_color50',
		array(
			'default'           => $color_scheme[50],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color50',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color51',
		array(
			'default'           => $color_scheme[51],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color51',
			array(
				'label'   => __( 'Pengumuman', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color52',
		array(
			'default'           => $color_scheme[52],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color52',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	    // Aksen
	$wp_customize->add_setting(
		'press_color53',
		array(
			'default'           => $color_scheme[53],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color53',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Halaman Baca
	$wp_customize->add_setting(
		'press_color54',
		array(
			'default'           => $color_scheme[54],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color54',
			array(
				'label'   => __( 'Span Title', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color55',
		array(
			'default'           => $color_scheme[55],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color55',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color56',
		array(
			'default'           => $color_scheme[56],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color56',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Form Komentar
	$wp_customize->add_setting(
		'press_color57',
		array(
			'default'           => $color_scheme[57],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color57',
			array(
				'label'   => __( 'Quotes', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color58',
		array(
			'default'           => $color_scheme[58],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color58',
			array(
				'description'   => __( 'Heading Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Submit
	$wp_customize->add_setting(
		'press_color59',
		array(
			'default'           => $color_scheme[59],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color59',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color60',
		array(
			'default'           => $color_scheme[60],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color60',
			array(
			    'label'   => __( 'Kepala Dan Guru', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Sidebar
	$wp_customize->add_setting(
		'press_color61',
		array(
			'default'           => $color_scheme[61],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color61',
			array(
				'label'   => __( 'Editorial Kepala', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color62',
		array(
			'default'           => $color_scheme[62],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color62',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color63',
		array(
			'default'           => $color_scheme[63],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color63',
			array(
			    'label'   => __( 'Editorial Read More', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color64',
		array(
			'default'           => $color_scheme[64],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color64',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Sidebar Tag
	$wp_customize->add_setting(
		'press_color65',
		array(
			'default'           => $color_scheme[65],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color65',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color66',
		array(
			'default'           => $color_scheme[66],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color66',
			array(
				'label'   => __( 'Guru Slide', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Footer
	$wp_customize->add_setting(
		'press_color67',
		array(
			'default'           => $color_scheme[67],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color67',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color68',
		array(
			'default'           => $color_scheme[68],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color68',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color69',
		array(
			'default'           => $color_scheme[69],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color69',
			array(
				'label'   => __( 'Block Blog, Fasilitas, Galeri', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color70',
		array(
			'default'           => $color_scheme[70],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color70',
			array(
			    'label'   => __( 'Blog Span Title', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Sidebar Tag
	$wp_customize->add_setting(
		'press_color71',
		array(
			'default'           => $color_scheme[71],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color71',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color72',
		array(
			'default'           => $color_scheme[72],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color72',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	// Copyright
	$wp_customize->add_setting(
		'press_color73',
		array(
			'default'           => $color_scheme[73],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color73',
			array(
				'label'   => __( 'Block Blog', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color74',
		array(
			'default'           => $color_scheme[74],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color74',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color75',
		array(
			'default'           => $color_scheme[75],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color75',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
    // Mobile Menu
	$wp_customize->add_setting(
		'press_color76',
		array(
			'default'           => $color_scheme[76],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color76',
			array(
				'label'   => __( 'Fasilitas', 'prestasi' ),
				'description'   => __( 'Heading Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color77',
		array(
			'default'           => $color_scheme[77],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color77',
			array(
			    'label'   => __( 'Kegiatan', 'prestasi' ),
				'description'   => __( 'Heading Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color78',
		array(
			'default'           => $color_scheme[78],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color78',
			array(
				'description'   => __( 'Box Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
    $wp_customize->add_setting(
		'press_color79',
		array(
			'default'           => $color_scheme[79],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color79',
			array(
				'description'   => __( 'Box Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color80',
		array(
			'default'           => $color_scheme[80],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color80',
			array(
			    'label'   => __( 'Galeri', 'prestasi' ),
				'description'   => __( 'Heading Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
    $wp_customize->add_setting(
		'press_color81',
		array(
			'default'           => $color_scheme[81],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color81',
			array(
			    'label'   => __( 'Video', 'prestasi' ),
				'description'   => __( 'Heading Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color82',
		array(
			'default'           => $color_scheme[82],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color82',
			array(
			    'label'   => __( 'Background Head Title', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color83',
		array(
			'default'           => $color_scheme[83],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color83',
			array(
				'description'   => __( 'Title Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color84',
		array(
			'default'           => $color_scheme[84],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color84',
			array(
				'label'   => __( 'Halaman Arsip', 'prestasi' ),
				'description'   => __( 'Heading Title Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color85',
		array(
			'default'           => $color_scheme[85],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color85',
			array(
				'label'   => __( 'Tanggal Pos', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color86',
		array(
			'default'           => $color_scheme[86],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color86',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color87',
		array(
			'default'           => $color_scheme[87],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color87',
			array(
				'label'   => __( 'Agenda Terlewat', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color88',
		array(
			'default'           => $color_scheme[88],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color88',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color89',
		array(
			'default'           => $color_scheme[89],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color89',
			array(
				'label'   => __( 'Guru / Ustadz / Dosen', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color90',
		array(
			'default'           => $color_scheme[90],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color90',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color91',
		array(
			'default'           => $color_scheme[91],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color91',
			array(
				'label'   => __( 'Download Table', 'prestasi' ),
				'description'   => __( 'Head Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color92',
		array(
			'default'           => $color_scheme[92],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color92',
			array(
				'description'   => __( 'Head Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color128',
		array(
			'default'           => $color_scheme[128],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color128',
			array(
				'description'   => __( 'Table Body Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color93',
		array(
			'default'           => $color_scheme[93],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color93',
			array(
				'description'   => __( 'Table Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color94',
		array(
			'default'           => $color_scheme[94],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color94',
			array(
				'description'   => __( 'Table Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color95',
		array(
			'default'           => $color_scheme[95],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color95',
			array(
				'label'   => __( 'Halaman Materi', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color96',
		array(
			'default'           => $color_scheme[96],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color96',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color97',
		array(
			'default'           => $color_scheme[97],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color97',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color98',
		array(
			'default'           => $color_scheme[98],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color98',
			array(
				'description'   => __( 'Box Soal BG', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color99',
		array(
			'default'           => $color_scheme[99],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color99',
			array(
				'description'   => __( 'Box Soal Border', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color100',
		array(
			'default'           => $color_scheme[100],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color100',
			array(
				'description'   => __( 'Box Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color101',
		array(
			'default'           => $color_scheme[101],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color101',
			array(
				'description'   => __( 'Box Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color102',
		array(
			'default'           => $color_scheme[102],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color102',
			array(
				'label'   => __( 'Halaman Pos', 'prestasi' ),
				'description'   => __( 'Agenda Countdown', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color103',
		array(
			'default'           => $color_scheme[103],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color103',
			array(
				'description'   => __( 'Agenda Expired', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color104',
		array(
			'default'           => $color_scheme[104],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color104',
			array(
				'description'   => __( 'Border Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color105',
		array(
			'default'           => $color_scheme[105],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color105',
			array(
				'description'   => __( 'Input BG', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color106',
		array(
			'default'           => $color_scheme[106],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color106',
			array(
				'description'   => __( 'Input Border', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color107',
		array(
			'default'           => $color_scheme[107],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color107',
			array(
				'description'   => __( 'Input Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color108',
		array(
			'default'           => $color_scheme[108],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color108',
			array(
				'description'   => __( 'Submit BG', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color109',
		array(
			'default'           => $color_scheme[109],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color109',
			array(
				'description'   => __( 'Submit Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color110',
		array(
			'default'           => $color_scheme[110],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color110',
			array(
				'label'   => __( 'Footer Widget', 'prestasi' ),
				'description'   => __( 'Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color111',
		array(
			'default'           => $color_scheme[111],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color111',
			array(
				'description'   => __( 'Text Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color112',
		array(
			'default'           => $color_scheme[112],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color112',
			array(
				'description'   => __( 'Link Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color113',
		array(
			'default'           => $color_scheme[113],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color113',
			array(
				'description'   => __( 'Tags Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color114',
		array(
			'default'           => $color_scheme[114],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color114',
			array(
				'description'   => __( 'Tags Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color115',
		array(
			'default'           => $color_scheme[115],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color115',
			array(
				'description'   => __( 'Copyright Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color116',
		array(
			'default'           => $color_scheme[116],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color116',
			array(
				'description'   => __( 'Copyright Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color117',
		array(
			'default'           => $color_scheme[117],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color117',
			array(
				'description'   => __( 'Copyright Link', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	
	$wp_customize->add_setting(
		'press_color118',
		array(
			'default'           => $color_scheme[118],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color118',
			array(
				'label'   => __( 'Footer Mobile Menu', 'prestasi' ),
				'description'   => __( 'Home Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color119',
		array(
			'default'           => $color_scheme[119],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color119',
			array(
				'description'   => __( 'Home Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color120',
		array(
			'default'           => $color_scheme[120],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color120',
			array(
				'description'   => __( 'Phone Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color121',
		array(
			'default'           => $color_scheme[121],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color121',
			array(
				'description'   => __( 'Phone Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color122',
		array(
			'default'           => $color_scheme[122],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color122',
			array(
				'description'   => __( 'Email Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color123',
		array(
			'default'           => $color_scheme[123],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color123',
			array(
				'description'   => __( 'Email Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color124',
		array(
			'default'           => $color_scheme[124],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color124',
			array(
				'description'   => __( 'WhatsApp Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color125',
		array(
			'default'           => $color_scheme[125],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color125',
			array(
				'description'   => __( 'WhatsApp Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color126',
		array(
			'default'           => $color_scheme[126],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color126',
			array(
				'description'   => __( 'Scroll Background', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'press_color127',
		array(
			'default'           => $color_scheme[127],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'press_color127',
			array(
				'description'   => __( 'Scroll Color', 'prestasi' ),
				'section' => 'colors',
			)
		)
	);

}
add_action( 'customize_register', 'prestasi_wp_customize_register', 11 );


if ( ! function_exists( 'prestasi_get_color_scheme' ) ) :
	
	function prestasi_get_color_scheme() {
		$color_scheme_option = get_theme_mod( 'color_scheme', 'default' );
		$color_schemes       = prestasi_get_color_schemes();

		if ( array_key_exists( $color_scheme_option, $color_schemes ) ) {
			return $color_schemes[ $color_scheme_option ]['colors'];
		}

		return $color_schemes['default']['colors'];
	}
endif; 

if ( ! function_exists( 'prestasi_get_color_scheme_choices' ) ) :
	
	function prestasi_get_color_scheme_choices() {
		$color_schemes                = prestasi_get_color_schemes();
		$color_scheme_control_options = array();

		foreach ( $color_schemes as $color_scheme => $value ) {
			$color_scheme_control_options[ $color_scheme ] = $value['label'];
		}

		return $color_scheme_control_options;
	}
endif; 

if ( ! function_exists( 'prestasi_sanitize_color_scheme' ) ) :
	
	function prestasi_sanitize_color_scheme( $value ) {
		$color_schemes = prestasi_get_color_scheme_choices();

		if ( ! array_key_exists( $value, $color_schemes ) ) {
			$value = 'default';
		}

		return $value;
	}
endif; 




