<?php

    function ajax_auth_init(){	
	
	    wp_register_script('validate-script', get_template_directory_uri() . '/javascript/jquery.validate.js', array('jquery') ); 
        wp_enqueue_script('validate-script');

        wp_register_script('ajax-auth-script', get_template_directory_uri() . '/javascript/ajax-auth-script.js', array('jquery') ); 
        wp_enqueue_script('ajax-auth-script');

        wp_localize_script( 'ajax-auth-script', 'ajax_auth_object', array( 
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'redirecturl' => get_the_permalink(),
            'loadingmessage' => __('Sedang Memeriksa Info, Tunggu Sebentar ...')
        ));
		

        add_action( 'wp_ajax_nopriv_ajaxlogin', 'ajax_login' );
	
	    add_action( 'wp_ajax_nopriv_ajaxregister', 'ajax_register' );
		
    }
	
	if (!is_user_logged_in()) {
        add_action('init', 'ajax_auth_init');
    }
  
    function ajax_login(){
	    check_ajax_referer( 'ajax-login-nonce', 'security' );
		auth_user_login($_POST['username'], $_POST['password'], 'Login'); 
		die();
    }

    function ajax_register(){
	    check_ajax_referer( 'ajax-register-nonce', 'security' );
		
		$info = array();
  	    $info['user_nicename'] = $info['nickname'] = $info['display_name'] = $info['first_name'] = $info['user_login'] = sanitize_user($_POST['username']) ;
        $info['user_pass'] = sanitize_text_field($_POST['password']);
	    $info['user_email'] = sanitize_email( $_POST['email']);
	
	    $user_register = wp_insert_user( $info );
 	        if ( is_wp_error($user_register) ){	
		        $error  = $user_register->get_error_codes()	;
				
				if(in_array('empty_user_login', $error))
		         	echo json_encode(array('loggedin'=>false, 'message'=>__($user_register->get_error_message('empty_user_login'))));
		        elseif(in_array('existing_user_login',$error))
			        echo json_encode(array('loggedin'=>false, 'message'=>__('Username Ini Sudah Digunakan, Silahkan Ganti Username Yang Lain')));
		        elseif(in_array('existing_user_email',$error))
                    echo json_encode(array('loggedin'=>false, 'message'=>__('Mohon Maaf Alamat Email Ini Telah Terdaftar. Silahkan Gunakan Email Yang Lain')));
            } else {
	            auth_user_login($info['nickname'], $info['user_pass'], 'Pendaftaran');       
            }
		die();
    }

    function auth_user_login($user_login, $password, $login) {
	    $info = array();
        $info['user_login'] = $user_login;
        $info['user_password'] = $password;
        $info['remember'] = true;
		
		$user_signon = wp_signon( $info, '' );
            if ( is_wp_error($user_signon) ){
	        	echo json_encode(array('loggedin'=>false, 'message'=>__('Salah Username atau Password.')));
            } else {
	        	wp_set_current_user($user_signon->ID); 
                echo json_encode(array('loggedin'=>true, 'message'=>__($login.' Berhasil, Menuju Halaman Materi ...')));
            }
		die();
    }
	
