<?php
/**
 * Customizer WP prestasi
 * Setting tema dari menu Customizer
 */

function prestasi_customize_register( $wp_customize ) {
	
$wp_customize->add_panel('prestasi_profile',array(
    'title'       => 'Prestasi : Pengaturan',
    'description' => 'Pengaturan Tema WP Prestasi',
    'priority'    => 40,
));

$wp_customize->add_section('prestasi_editor',array(
    'title'       => 'Pilihan Editor',
    'description' => 'WordPress Memiliki 2 Jenis Editor Untuk Menulis Konten, Editor Yang Terkini Bernama Gutenberg (Editor Berbentuk Block Builder) Yang Terkadang Membuat Loading Agak Berat, Editor Yang Kedua Adalah Editor Versi Lama atau Disebut Classic Editor Yang Jauh Lebih Ringan dan familiar Dari Segi Kemudahan. <br/><br/>Opsi Ini Tidak Berlaku Untuk <strong>Pos</strong> dan <strong>Laman</strong>, Hanya Untuk Pos Bawaan Tema (Agenda, Pengumuman, dll...)',
    'priority'    => 10,
    'panel'       => 'prestasi_profile',
));

// Nama Usaha
$wp_customize->add_setting('opsi_editor',array(
    'default'     => 'true',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('opsi_editor',array(
    'label'        => 'Pilih Editor',
	'description'  => 'Pilihan Editor Untuk Menulis',
    'type'         => 'select',
	'choices'     => array(
		'true'      => __( 'Gutenberg (Editor Block)', 'prestasi' ),
		'false'     => __( 'Classic Editor (Mode WYSIWYG)', 'prestasi' ),
	),
    'section'      => 'prestasi_editor',
    'settings'     => 'opsi_editor',
));

$wp_customize->add_section('profile_sekolah',array(
    'title'       => 'Profile Sekolah',
    'description' => 'Lengkapi Data Profile Sekolah',
    'priority'    => 10,
    'panel'       => 'prestasi_profile',
));

// Nama Usaha
$wp_customize->add_setting('sekolah_type',array(
    'default'     => 'sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('sekolah_type',array(
    'label'        => 'Kategori Sekolah',
	'description'  => 'PENTING : Setiap Kali Memilih Kategori Sekolah, Selanjutnya WAJIB Untuk Melakukan <a target="_blank" href="'. admin_url( 'options-permalink.php', 'https' ) .'">Update Permalink</a> Supaya Fitur Sesuai Kategori Sekolah Berjalan Dengan Baik dan Tidak Muncul 404',
    'type'         => 'select',
	'choices'     => array(
		'sekolah'      => __( 'Umum, Madrasah, Kejuruan', 'prestasi' ),
		'pesantren'    => __( 'Pesantren', 'prestasi' ),
		'akademi'      => __( 'Sekolah Tinggi', 'prestasi' ),
	),
    'section'      => 'profile_sekolah',
    'settings'     => 'sekolah_type',
));
$wp_customize->add_setting('nama_sekolah',array(
    'default'     => 'Sekolahku Keren',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('nama_sekolah',array(
    'label'        => 'Nama Sekolah',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'nama_sekolah',
));
$wp_customize->add_setting('kepala_sekolah',array(
    'default'     => 'Azan Fadli Mulyadi, S.Kom',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('kepala_sekolah',array(
    'label'        => 'Nama Pimpinan',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'kepala_sekolah',
));
// Foto Kepala
$wp_customize->add_setting( 'foto_kepala', array(
    'default' => get_theme_file_uri('images/photo.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'foto_kepala', array(
    'label'         => 'Foto Pimpinan',
	'description'   => 'Upload Foto Mode Pas Photo (300x400 pixel)',
    'section'       => 'profile_sekolah',
    'settings'      => 'foto_kepala',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// NSPN
$wp_customize->add_setting('nspn_data',array(
    'default'     => '00101091',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('nspn_data',array(
    'label'        => 'NSPN',
	'description'  => 'Nomor Pokok Sekolah Nasional',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'nspn_data',
));
// Alamat
$wp_customize->add_setting('address_data',array(
    'default'     => 'Jl Keren No. 10, Kota Keren, Paling Keren',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('address_data',array(
    'label'        => 'Alamat',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'address_data',
));

// Nomer Telepon
$wp_customize->add_setting('telpon_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('telpon_data',array(
    'label'        => 'Nomer Telpon',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'telpon_data',
));
// Alamat Email
$wp_customize->add_setting('email_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'sanitize_email'
));
$wp_customize->add_control('email_data',array(
    'label'        => 'Alamat Email',
    'type'         => 'email',
    'section'      => 'profile_sekolah',
    'settings'     => 'email_data',
));
// WhatsApp
$wp_customize->add_setting('wa_data',array(
    'default'     => '+62-82138390110',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('wa_data',array(
    'label'        => 'WhatsApp',
	'description'  => 'Awali Dengan 62 Bukan 0',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'wa_data',
));

// Facebook
$wp_customize->add_setting('facebook_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('facebook_data',array(
    'label'        => 'Facebook',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'facebook_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'prestasi' ),
    )
));
// Twitter
$wp_customize->add_setting('twitter_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('twitter_data',array(
    'label'        => 'Twitter',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'twitter_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'prestasi' ),
    )
));
// Instagram
$wp_customize->add_setting('instagram_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('instagram_data',array(
    'label'       => 'Instagram',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'instagram_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'prestasi' ),
    )
));
// Youtube
$wp_customize->add_setting('youtube_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('youtube_data',array(
    'label'       => 'Youtube',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'youtube_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'prestasi' ),
    )
));
	

$wp_customize->add_section('prestasi_runing',array(
    'title'       => 'Running Text',
    'description' => 'Tambahkan Konten Untuk Runing Text, Tag HTML Diperbolehkan Tetapi Harap Minimalkan Agar Tidak Merusak Tampilan, Gunakan Hanya<br/> &lt;strong&gt;<strong>Huruf Tebal</strong>&lt;/strong&gt;<br/>&lt;em&gt;<em>Huruf Miring</em>&lt;/em&gt;<br/>&lt;a href="https://.."&gt;<a href="#">Link / Tautan</a>&lt;/a&gt; ',
    'priority'    => 30,
    'panel'       => 'prestasi_profile',
));
// Run
$wp_customize->add_setting('running_text',array(
    'default'     => 'Tema Prestasi Dapat Menampilkan Informasi Dalam Text Berjalan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('running_text',array(
    'label'        => 'Isi Running Text',
    'type'         => 'textarea',
    'section'      => 'prestasi_runing',
    'settings'     => 'running_text',
));


	
$wp_customize->add_section('replace_text',array(
    'title'       => 'Replace Text',
    'description' => 'Gunakan Untuk Mengganti Beberapa Text Default Bawaan Tema',
    'priority'    => 20,
    'panel'       => 'prestasi_profile',
));

$wp_customize->add_setting('re_info',array(
    'default'     => 'Info Sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_info',array(
    'label'        => 'Info Sekolah',
	'description'  => 'Lokasi Dibawah Slider di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_info',
));

$wp_customize->add_setting('re_kontak',array(
    'default'     => 'Kontak Sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_kontak',array(
    'label'        => 'Kontak Sekolah',
	'description'  => 'Lokasi Dibawah Slider di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_kontak',
));

$wp_customize->add_setting('re_agenda',array(
    'default'     => 'Agenda Terbaru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_agenda',array(
    'label'        => 'Agenda Terbaru',
	'description'  => 'Lokasi Pada Blok Agenda di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_agenda',
));
$wp_customize->add_setting('re_seeagenda',array(
    'default'     => 'Lihat Agenda',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_seeagenda',array(
    'label'        => 'Lihat Agenda',
	'description'  => 'Lokasi Pada Blok Agenda di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_seeagenda',
));

$wp_customize->add_setting('re_pengumuman',array(
    'default'     => 'Pengumuman',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_pengumuman',array(
    'label'        => 'Pengumuman',
	'description'  => 'Lokasi Pada Blok Agenda di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_pengumuman',
));

$wp_customize->add_setting('re_quotes',array(
    'default'     => 'Quotes',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_quotes',array(
    'label'        => 'Quotes',
	'description'  => 'Lokasi Pada Slide Quotes di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_quotes',
));

$wp_customize->add_setting('re_kepala',array(
    'default'     => 'Kepala Sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_kepala',array(
    'label'        => 'Kepala Sekolah',
	'description'  => 'Lokasi Pada Foto Kepala Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_kepala',
));

$wp_customize->add_setting('re_editorial',array(
    'default'     => 'Editorial',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_editorial',array(
    'label'        => 'Editorial',
	'description'  => 'Lokasi Pada Foto Kepala Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_editorial',
));

$wp_customize->add_setting('re_editormore',array(
    'default'     => 'Selengkapnya',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_editormore',array(
    'label'        => 'Selengkapnya',
	'description'  => 'Lokasi Pada Foto Kepala Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_editormore',
));

$wp_customize->add_setting('re_guru',array(
    'default'     => 'Daftar Guru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_guru',array(
    'label'        => 'Daftar Guru',
	'description'  => 'Lokasi Pada Daftar Guru di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_guru',
));

$wp_customize->add_setting('re_blog',array(
    'default'     => 'Blog Guru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_blog',array(
    'label'        => 'Blog Guru',
	'description'  => 'Lokasi Pada Foto Blog Guru di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_blog',
));

$wp_customize->add_setting('re_fasilitas',array(
    'default'     => 'Fasilitas',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_fasilitas',array(
    'label'        => 'Fasilitas',
	'description'  => 'Lokasi Pada Fasilitas Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_fasilitas',
));

$wp_customize->add_setting('re_kegiatan',array(
    'default'     => 'Kegiatan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_kegiatan',array(
    'label'        => 'Kegiatan',
	'description'  => 'Lokasi Pada Kegiatan Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_kegiatan',
));

$wp_customize->add_setting('re_lihat',array(
    'default'     => 'Lihat Kegiatan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_lihat',array(
    'label'        => 'Lihat Kegiatan',
	'description'  => 'Lokasi Pada Kegiatan Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_lihat',
));

$wp_customize->add_setting('re_galeri',array(
    'default'     => 'Galeri',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_galeri',array(
    'label'        => 'Galeri',
	'description'  => 'Lokasi Pada Galeri Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_galeri',
));

$wp_customize->add_setting('re_video',array(
    'default'     => 'Video',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_video',array(
    'label'        => 'Video',
	'description'  => 'Lokasi Pada Video Sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_video',
));

$wp_customize->add_setting('re_news',array(
    'default'     => 'Berita Terbaru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_news',array(
    'label'        => 'Berita Terbaru',
	'description'  => 'Lokasi di Daftar Artikel Terbaru',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_news',
));

// 404
$wp_customize->add_setting('re_head404',array(
    'default'     => '404, Halaman Tidak Ditemukan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_head404',array(
    'label'        => 'Judul 404',
	'description'  => 'Lokasi di Halaman 404',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_head404',
));
$wp_customize->add_setting('re_text404',array(
    'default'     => 'Halaman Ini Tidak Tersedia atau Mungkin Sudah Kadaluarsa',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_text404',array(
    'label'        => 'Text 404',
	'description'  => 'Lokasi di Halaman 404',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_text404',
));

// Footer
$wp_customize->add_setting('copy_foot',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('copy_foot',array(
    'label'        => 'Footer Copyright',
	'description'  => 'Mengganti Text Copyright Pada Footer Website',
    'type'         => 'textarea',
    'section'      => 'replace_text',
    'settings'     => 'copy_foot',
));





// Layout Setting
$wp_customize->add_section('prestasi_layout',array(
    'title'       => 'Layout Setting',
    'description' => 'Pengaturan Terkait Dengan Tampilan Konten Bawaan Tema',
    'priority'    => 40,
    'panel'       => 'prestasi_profile',
));
// Foto Share
$wp_customize->add_setting( 'share_image', array(
    'default' => get_theme_file_uri('images/share.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'share_image', array(
    'label' => 'Gambar Default Share',
	'description' => 'Atur Sebuah Gambar Yang Akan Menjadi Gambar Default Jika Link di Share ke Facebook, Twitter, dan WhatsApp',
    'section' => 'prestasi_layout',
    'settings' => 'share_image',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// Thumbnail
$wp_customize->add_setting( 'pressthumb_image', array(
    'default' => get_theme_file_uri('images/prestasi.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pressthumb_image', array(
    'label' => 'Default Gambar Unggulan',
	'description' => 'Atur Sebuah Gambar Yang Akan Menjadi Gambar Default Jika Tidak Ada Gambar Unggulan',
    'section' => 'prestasi_layout',
    'settings' => 'pressthumb_image',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// Slide
$wp_customize->add_setting('slide_width',array(
    'default'     => 1200,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_width',array(
    'label'        => 'Ganti Ukuran Slider',
	'description' => 'PENTING : Setelah Ukuran Baru Tersimpan. WAJIB Melakukan <a target="_blank" href="'. esc_url('https://ciuss.com/regenerate') .'">Re-generate Thumbnail</a> Agar Ukuran Baru Tersebut Bekerja ke Semua Gambar.',
    'type'         => 'number',
    'section'      => 'prestasi_layout',
    'settings'     => 'slide_width',
));
$wp_customize->add_setting('slide_height',array(
    'default'     => 600,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_height',array(
    'type'         => 'number',
    'section'      => 'prestasi_layout',
    'settings'     => 'slide_height',
));

$wp_customize->add_setting('slide_timer',array(
    'default'     => 6,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'theme_slug_sanitize_select'
));
$wp_customize->add_control('slide_timer',array(
    'label'        => 'Durasi Pergantian Slide',
	'description'  => 'Efek Perubahan Bisa Dilihat Pada Slide ke Halaman Beranda',
    'type'         => 'select',
	'choices'     => array(
		'3'      => __( '3 Detik', 'prestasi' ),
		'4'      => __( '4 Detik', 'prestasi' ),
		'5'      => __( '5 Detik', 'prestasi' ),
		'6'      => __( '6 Detik', 'prestasi' ),
		'7'      => __( '7 Detik', 'prestasi' ),
		'8'      => __( '8 Detik', 'prestasi' ),
		'9'      => __( '9 Detik', 'prestasi' ),
		'10'     => __( '10 Detik', 'prestasi' ),
	),
    'section'      => 'prestasi_layout',
    'settings'     => 'slide_timer',
));

// Title Parallax
$wp_customize->add_setting('bread_parallax',array(
    'default'     => get_theme_file_uri('images/parallax.jpg'),
	'sanitize_callback' => 'esc_url_raw'
));

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bread_parallax', array(
    'label'        => 'Background Post/Page Title',
    'section'      => 'prestasi_layout',
    'settings'     => 'bread_parallax',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
$wp_customize->add_setting('bread_opacity',array(
    'default'     => 90,
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('bread_opacity',array(
    'label'        => 'Bakground Transparan',
    'type'         => 'number',
    'section'      => 'prestasi_layout',
    'settings'     => 'bread_opacity',
	'input_attrs' => array(
        'min'     => 1,
		'max'     => 99,
    )
));

// Border
$wp_customize->add_setting('box_style',array(
    'default'     => 'kotak',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('box_style',array(
    'label'        => 'Pilih Style Button',
	'description'  => 'Hasil Dapat Dilihat Setelah Refresh Laman',
    'type'         => 'select',
	'choices'     => array(
		'kotak'      => __( 'Kotak', 'prestasi' ),
		'bulat'     => __( 'Bulat', 'prestasi' ),
		'lengkung'     => __( 'Lengkung', 'prestasi' ),
	),
    'section'      => 'prestasi_layout',
    'settings'     => 'box_style',
));

// WhatsApp Section
$wp_customize->add_section('wa_section',array(
    'title'       => 'Setting WhatsApp',
    'description' => 'Gunakan Untuk Mengganti Text Pesan WhatsApp Bawaan Tema',
    'priority'    => 80,
    'panel'       => 'prestasi_profile',
));

$wp_customize->add_setting('chat_sekolah',array(
    'default'     => 'Saya Ingin Informasi Seputar Sekolah ...',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('chat_sekolah',array(
    'label'        => 'Pesan Umum',
	'description'  => 'Ubah Pesan Default Tombol WhatsApp Utama',
    'type'         => 'text',
    'section'      => 'wa_section',
    'settings'     => 'chat_sekolah',
));

}
add_action( 'customize_register', 'prestasi_customize_register', 11 );


