<?php

function additional_user_fields( $user ) { ?>
	    <h3><?php _e( 'Tambah Foto Profile', 'textdomain' ); ?></h3>
		<?php wp_enqueue_media(); ?>
	
	    <script>
	    	jQuery(document).ready(function($){
			    var file_frame;
				$('.additional-user-image').on('click', function( event ){
				    event.preventDefault();
					
					if ( file_frame ) {
				    	file_frame.open();
						return;
					}
					
					file_frame = wp.media.frames.file_frame = wp.media({
					    title: $( this ).data( 'uploader_title' ),
						button: {
						text: $( this ).data( 'uploader_button_text' ),
					},
					multiple: false  
				});
				
				file_frame.on( 'select', function() {
			    	attachment = file_frame.state().get('selection').first().toJSON();
					jQuery(".foto").attr('value', attachment.url);
					jQuery('img.image-preview').attr('src', attachment.sizes.full.url);
				});
				
				file_frame.open();
			});
		});
	</script>
	
	<table id="upgrade" class="form-table">
        <tbody>
		<tr class="user-description-wrap">
			<th><label for="user_meta_image"><?php _e( 'Photo Profile', 'textdomain' ); ?></label></th>
			<td>
				<img class="image-preview" src="<?php echo esc_url( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>" style="width:150px; margin: 0 20px 0 0; float: left;">
				<input type="hidden" name="user_meta_image" class="foto" id="user_meta_image" value="<?php echo esc_url_raw( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>" class="regular-text" />
				<input type='button' class="additional-user-image button-primary" value="<?php _e( 'Unggah Photo', 'textdomain' ); ?>" id="uploadimage"/><br />
				<p class="description"><?php _e( 'Tambahkan Sebuah Gambar Untuk Dijadikan Sebagai Gambar Profile.', 'textdomain' ); ?></p>
			</td>
		</tr>
	</table>
	
<?php } 

    add_action( 'show_user_profile', 'additional_user_fields' );
    add_action( 'edit_user_profile', 'additional_user_fields' );
	
	function save_additional_user_meta( $user_id ) {
    	if ( !current_user_can( 'edit_user', $user_id ) )
	    	return false;

		update_user_meta( $user_id, 'user_meta_image', $_POST['user_meta_image'] );
	}

	add_action( 'personal_options_update', 'save_additional_user_meta' );
	add_action( 'edit_user_profile_update', 'save_additional_user_meta' );
	
	function get_attachment_image_by_url( $url ) {
    	$parse_url  = explode( parse_url( WP_CONTENT_URL, PHP_URL_PATH ), $url );
		$this_host = str_ireplace( 'www.', '', parse_url( home_url(), PHP_URL_HOST ) );
        $file_host = str_ireplace( 'www.', '', parse_url( $url, PHP_URL_HOST ) );
		
		if ( !isset( $parse_url[1] ) || empty( $parse_url[1] ) || ( $this_host != $file_host ) ) {
	    	return;
        }
		
		global $wpdb;
 
        $prefix     = $wpdb->prefix;
        $attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM " . $prefix . "posts WHERE guid RLIKE %s;", $parse_url[1] ) );
		
		return $attachment[0];
    }
	
	function get_additional_user_meta_thumb() {
    	$attachment_url = esc_url( get_the_author_meta( 'user_meta_image', $post->post_author ) );
		$attachment_id = get_attachment_image_by_url( $attachment_url );
		$image_thumb = wp_get_attachment_image_src( $attachment_id, 'thumbnail' );
		return $image_thumb[0];
	}
    
    add_role('guru',
            'Guru',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );

    add_role('operator',
            'Operator',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );
	
	add_role('master',
            'Kepala Sekolah',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );
	
	add_role('siswa',
            'Siswa / Mahasiswa',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );

function add_master_caps() {
    // gets the administrator role
    $presscap = get_role( 'master' );

    $presscap->add_cap( 'read' ); 
	$presscap->add_cap( 'upload_files' );
	
        $presscap->add_cap( 'edit_editorial' ); 
        $presscap->add_cap( 'edit_editorials' );
	    $presscap->add_cap( 'edit_other_editorials' );
    	$presscap->add_cap( 'edit_private_editorials' );
	    $presscap->add_cap( 'edit_published_editorials' );
    	$presscap->add_cap( 'read_editorial' ); 
    	$presscap->add_cap( 'read_private_editorials' );
    	$presscap->add_cap( 'publish_editorials' );
    	$presscap->add_cap( 'delete_editorial' ); 
        $presscap->add_cap( 'delete_editorials' );
    	$presscap->add_cap( 'delete_private_editorials' );
    	$presscap->add_cap( 'delete_others_editorials' );
    	$presscap->add_cap( 'delete_published_editorials' ); 
	
}
add_action( 'admin_init', 'add_master_caps');

function add_gurus_caps() {
    // gets the administrator role
    $presscap = get_role( 'guru' );

    $presscap->add_cap( 'read' ); 
	$presscap->add_cap( 'upload_files' );
	
	    $presscap->add_cap( 'edit_blog' ); 
        $presscap->add_cap( 'edit_blogs' );
	    $presscap->remove_cap( 'edit_other_blogs' );
    	$presscap->add_cap( 'edit_private_blogs' );
	    $presscap->add_cap( 'edit_published_blogs' );
    	$presscap->add_cap( 'read_blog' ); 
    	$presscap->add_cap( 'read_private_blogs' );
    	$presscap->add_cap( 'publish_blogs' );
    	$presscap->add_cap( 'delete_blog' ); 
        $presscap->add_cap( 'delete_blogs' );
    	$presscap->add_cap( 'delete_private_blogs' );
    	$presscap->remove_cap( 'delete_others_blogs' );
    	$presscap->add_cap( 'delete_published_blogs' ); 
	
	$presscap->add_cap( 'manage_blogkat' ); 
	$presscap->add_cap( 'assign_blogkat' ); 
	$presscap->add_cap( 'edit_blogkat' ); 
	
        $presscap->add_cap( 'edit_down' ); 
        $presscap->add_cap( 'edit_downs' );
	    $presscap->remove_cap( 'edit_other_downs' );
    	$presscap->add_cap( 'edit_private_downs' );
	    $presscap->add_cap( 'edit_published_downs' );
    	$presscap->add_cap( 'read_down' ); 
    	$presscap->add_cap( 'read_private_downs' );
    	$presscap->add_cap( 'publish_downs' );
    	$presscap->add_cap( 'delete_down' ); 
        $presscap->add_cap( 'delete_downs' );
    	$presscap->add_cap( 'delete_private_downs' );
    	$presscap->remove_cap( 'delete_others_downs' );
    	$presscap->add_cap( 'delete_published_downs' ); 
		
	$presscap->add_cap( 'manage_catdown' ); 
	$presscap->add_cap( 'assign_catdown' ); 
	$presscap->add_cap( 'edit_catdown' ); 
	
	$presscap->add_cap( 'manage_typedown' ); 
	$presscap->add_cap( 'assign_typedown' ); 
	$presscap->add_cap( 'edit_typedown' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $presscap->add_cap( 'edit_dosen' ); 
        $presscap->add_cap( 'edit_dosens' );
	    $presscap->remove_cap( 'edit_other_dosens' );
    	$presscap->add_cap( 'edit_private_dosens' );
	    $presscap->add_cap( 'edit_published_dosens' );
    	$presscap->add_cap( 'read_dosen' ); 
    	$presscap->add_cap( 'read_private_dosens' );
    	$presscap->add_cap( 'publish_dosens' );
    	$presscap->add_cap( 'delete_dosen' ); 
        $presscap->add_cap( 'delete_dosens' );
    	$presscap->add_cap( 'delete_private_dosens' );
    	$presscap->remove_cap( 'delete_others_dosens' );
    	$presscap->add_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $presscap->add_cap( 'edit_ustadz' ); 
        $presscap->add_cap( 'edit_ustadzs' );
	    $presscap->remove_cap( 'edit_other_ustadzs' );
    	$presscap->add_cap( 'edit_private_ustadzs' );
	    $presscap->add_cap( 'edit_published_ustadzs' );
    	$presscap->add_cap( 'read_ustadz' ); 
    	$presscap->add_cap( 'read_private_ustadzs' );
    	$presscap->add_cap( 'publish_ustadzs' );
    	$presscap->add_cap( 'delete_ustadz' ); 
        $presscap->add_cap( 'delete_ustadzs' );
    	$presscap->add_cap( 'delete_private_ustadzs' );
    	$presscap->remove_cap( 'delete_others_ustadzs' );
    	$presscap->add_cap( 'delete_published_ustadzs' ); 
	} else {
        $presscap->add_cap( 'edit_guru' ); 
        $presscap->add_cap( 'edit_gurus' );
	    $presscap->remove_cap( 'edit_other_gurus' );
    	$presscap->add_cap( 'edit_private_gurus' );
	    $presscap->add_cap( 'edit_published_gurus' );
    	$presscap->add_cap( 'read_guru' ); 
    	$presscap->add_cap( 'read_private_gurus' );
    	$presscap->add_cap( 'publish_gurus' );
    	$presscap->add_cap( 'delete_guru' ); 
        $presscap->add_cap( 'delete_gurus' );
    	$presscap->add_cap( 'delete_private_gurus' );
    	$presscap->remove_cap( 'delete_others_gurus' );
    	$presscap->add_cap( 'delete_published_gurus' ); 
	}
	
	$presscap->add_cap( 'manage_jab' ); 
	$presscap->add_cap( 'assign_jab' ); 
	$presscap->add_cap( 'edit_jab' ); 
	
	$presscap->add_cap( 'manage_stts' ); 
	$presscap->add_cap( 'assign_stts' ); 
	$presscap->add_cap( 'edit_stts' ); 
	
	    $presscap->add_cap( 'edit_tugas' ); 
        $presscap->add_cap( 'edit_tugass' );
	    $presscap->remove_cap( 'edit_other_tugass' );
    	$presscap->add_cap( 'edit_private_tugass' );
	    $presscap->add_cap( 'edit_published_tugass' );
    	$presscap->add_cap( 'read_tugas' ); 
    	$presscap->add_cap( 'read_private_tugass' );
    	$presscap->add_cap( 'publish_tugass' );
    	$presscap->add_cap( 'delete_tugas' ); 
        $presscap->add_cap( 'delete_tugass' );
    	$presscap->add_cap( 'delete_private_tugass' );
    	$presscap->remove_cap( 'delete_others_tugass' );
    	$presscap->add_cap( 'delete_published_tugass' );
		
	$presscap->add_cap( 'manage_level' ); 
   	$presscap->add_cap( 'assign_level' ); 
	$presscap->add_cap( 'edit_level' );
	$presscap->add_cap( 'manage_mapel' ); 
   	$presscap->add_cap( 'assign_mapel' ); 
	$presscap->add_cap( 'edit_mapel' );
}
add_action( 'admin_init', 'add_gurus_caps');

function add_operator_caps() {
    
    $presscap = get_role( 'operator' );

    $presscap->add_cap( 'read' ); 
	$presscap->add_cap( 'upload_files' );
	
        $presscap->add_cap( 'edit_acara' ); 
        $presscap->add_cap( 'edit_acaras' );
	    $presscap->add_cap( 'edit_other_acaras' );
    	$presscap->add_cap( 'edit_private_acaras' );
	    $presscap->add_cap( 'edit_published_acaras' );
    	$presscap->add_cap( 'read_acara' ); 
    	$presscap->add_cap( 'read_private_acaras' );
    	$presscap->add_cap( 'publish_acaras' );
    	$presscap->add_cap( 'delete_acara' ); 
        $presscap->add_cap( 'delete_acaras' );
    	$presscap->add_cap( 'delete_private_acaras' );
    	$presscap->add_cap( 'delete_others_acaras' );
    	$presscap->add_cap( 'delete_published_acaras' ); 
		
		$presscap->add_cap( 'edit_post' ); 
        $presscap->add_cap( 'edit_posts' );
	    $presscap->add_cap( 'edit_other_posts' );
    	$presscap->add_cap( 'edit_private_posts' );
	    $presscap->add_cap( 'edit_published_posts' );
    	$presscap->add_cap( 'read_post' ); 
    	$presscap->add_cap( 'read_private_posts' );
    	$presscap->add_cap( 'publish_posts' );
    	$presscap->add_cap( 'delete_post' ); 
        $presscap->add_cap( 'delete_posts' );
    	$presscap->add_cap( 'delete_private_posts' );
    	$presscap->add_cap( 'delete_others_posts' );
    	$presscap->add_cap( 'delete_published_posts' ); 
		
	$presscap->add_cap( 'manage_categories' ); 
	$presscap->add_cap( 'assign_categories' ); 
	$presscap->add_cap( 'edit_categories' ); 
		
		$presscap->add_cap( 'edit_page' ); 
        $presscap->add_cap( 'edit_pages' );
	    $presscap->add_cap( 'edit_other_pages' );
    	$presscap->add_cap( 'edit_private_pages' );
	    $presscap->add_cap( 'edit_published_pages' );
    	$presscap->add_cap( 'read_page' ); 
    	$presscap->add_cap( 'read_private_pages' );
    	$presscap->add_cap( 'publish_pages' );
    	$presscap->add_cap( 'delete_page' ); 
        $presscap->add_cap( 'delete_pages' );
    	$presscap->add_cap( 'delete_private_pages' );
    	$presscap->add_cap( 'delete_others_pages' );
    	$presscap->add_cap( 'delete_published_pages' ); 
		
	if ( get_theme_mod('sekolah_type') != "akademi" ) {
        $presscap->add_cap( 'edit_extra' ); 
        $presscap->add_cap( 'edit_extras' );
	    $presscap->add_cap( 'edit_other_extras' );
    	$presscap->add_cap( 'edit_private_extras' );
	    $presscap->add_cap( 'edit_published_extras' );
    	$presscap->add_cap( 'read_extra' ); 
    	$presscap->add_cap( 'read_private_extras' );
    	$presscap->add_cap( 'publish_extras' );
    	$presscap->add_cap( 'delete_extra' ); 
        $presscap->add_cap( 'delete_extras' );
    	$presscap->add_cap( 'delete_private_extras' );
    	$presscap->add_cap( 'delete_others_extras' );
    	$presscap->add_cap( 'delete_published_extras' ); 
	} else {
        $presscap->add_cap( 'edit_kegiatan' ); 
        $presscap->add_cap( 'edit_kegiatans' );
	    $presscap->add_cap( 'edit_other_kegiatans' );
    	$presscap->add_cap( 'edit_private_kegiatans' );
	    $presscap->add_cap( 'edit_published_kegiatans' );
    	$presscap->add_cap( 'read_kegiatan' ); 
    	$presscap->add_cap( 'read_private_kegiatans' );
    	$presscap->add_cap( 'publish_kegiatans' );
    	$presscap->add_cap( 'delete_kegiatan' ); 
        $presscap->add_cap( 'delete_kegiatans' );
    	$presscap->add_cap( 'delete_private_kegiatans' );
    	$presscap->add_cap( 'delete_others_kegiatans' );
    	$presscap->add_cap( 'delete_published_kegiatans' ); 
	}
        $presscap->add_cap( 'edit_fasil' ); 
        $presscap->add_cap( 'edit_fasils' );
	    $presscap->add_cap( 'edit_other_fasils' );
    	$presscap->add_cap( 'edit_private_fasils' );
	    $presscap->add_cap( 'edit_published_fasils' );
    	$presscap->add_cap( 'read_fasil' ); 
    	$presscap->add_cap( 'read_private_fasils' );
    	$presscap->add_cap( 'publish_fasils' );
    	$presscap->add_cap( 'delete_fasil' ); 
        $presscap->add_cap( 'delete_fasils' );
    	$presscap->add_cap( 'delete_private_fasils' );
    	$presscap->add_cap( 'delete_others_fasils' );
    	$presscap->add_cap( 'delete_published_fasils' ); 
		
        $presscap->add_cap( 'edit_galer' ); 
        $presscap->add_cap( 'edit_galers' );
	    $presscap->add_cap( 'edit_other_galers' );
    	$presscap->add_cap( 'edit_private_galers' );
	    $presscap->add_cap( 'edit_published_galers' );
    	$presscap->add_cap( 'read_galer' ); 
    	$presscap->add_cap( 'read_private_galers' );
    	$presscap->add_cap( 'publish_galers' );
    	$presscap->add_cap( 'delete_galer' ); 
        $presscap->add_cap( 'delete_galers' );
    	$presscap->add_cap( 'delete_private_galers' );
    	$presscap->add_cap( 'delete_others_galers' );
    	$presscap->add_cap( 'delete_published_galers' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $presscap->add_cap( 'edit_maha' ); 
        $presscap->add_cap( 'edit_mahas' );
	    $presscap->add_cap( 'edit_other_mahas' );
    	$presscap->add_cap( 'edit_private_mahas' );
	    $presscap->add_cap( 'edit_published_mahas' );
    	$presscap->add_cap( 'read_maha' ); 
    	$presscap->add_cap( 'read_private_mahas' );
    	$presscap->add_cap( 'publish_mahas' );
    	$presscap->add_cap( 'delete_maha' ); 
        $presscap->add_cap( 'delete_mahas' );
    	$presscap->add_cap( 'delete_private_mahas' );
    	$presscap->add_cap( 'delete_others_mahas' );
    	$presscap->add_cap( 'delete_published_mahas' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $presscap->add_cap( 'edit_santri' ); 
        $presscap->add_cap( 'edit_santris' );
	    $presscap->add_cap( 'edit_other_santris' );
    	$presscap->add_cap( 'edit_private_santris' );
	    $presscap->add_cap( 'edit_published_santris' );
    	$presscap->add_cap( 'read_santri' ); 
    	$presscap->add_cap( 'read_private_santris' );
    	$presscap->add_cap( 'publish_santris' );
    	$presscap->add_cap( 'delete_santri' ); 
        $presscap->add_cap( 'delete_santris' );
    	$presscap->add_cap( 'delete_private_santris' );
    	$presscap->add_cap( 'delete_others_santris' );
    	$presscap->add_cap( 'delete_published_santris' ); 
	} else {
        $presscap->add_cap( 'edit_siswa' ); 
        $presscap->add_cap( 'edit_siswas' );
	    $presscap->add_cap( 'edit_other_siswas' );
    	$presscap->add_cap( 'edit_private_siswas' );
	    $presscap->add_cap( 'edit_published_siswas' );
    	$presscap->add_cap( 'read_siswa' ); 
    	$presscap->add_cap( 'read_private_siswas' );
    	$presscap->add_cap( 'publish_siswas' );
    	$presscap->add_cap( 'delete_siswa' ); 
        $presscap->add_cap( 'delete_siswas' );
    	$presscap->add_cap( 'delete_private_siswas' );
    	$presscap->add_cap( 'delete_others_siswas' );
    	$presscap->add_cap( 'delete_published_siswas' ); 
	}
        $presscap->add_cap( 'edit_peng' ); 
        $presscap->add_cap( 'edit_pengs' );
	    $presscap->add_cap( 'edit_other_pengs' );
    	$presscap->add_cap( 'edit_private_pengs' );
	    $presscap->add_cap( 'edit_published_pengs' );
    	$presscap->add_cap( 'read_peng' ); 
    	$presscap->add_cap( 'read_private_pengs' );
    	$presscap->add_cap( 'publish_pengs' );
    	$presscap->add_cap( 'delete_peng' ); 
        $presscap->add_cap( 'delete_pengs' );
    	$presscap->add_cap( 'delete_private_pengs' );
    	$presscap->add_cap( 'delete_others_pengs' );
    	$presscap->add_cap( 'delete_published_pengs' ); 
		
		$presscap->add_cap( 'edit_prest' ); 
        $presscap->add_cap( 'edit_prests' );
	    $presscap->add_cap( 'edit_other_prests' );
    	$presscap->add_cap( 'edit_private_prests' );
	    $presscap->add_cap( 'edit_published_prests' );
    	$presscap->add_cap( 'read_prest' ); 
    	$presscap->add_cap( 'read_private_prests' );
    	$presscap->add_cap( 'publish_prests' );
    	$presscap->add_cap( 'delete_prest' ); 
        $presscap->add_cap( 'delete_prests' );
    	$presscap->add_cap( 'delete_private_prests' );
    	$presscap->add_cap( 'delete_others_prests' );
    	$presscap->add_cap( 'delete_published_prests' ); 
		
        $presscap->add_cap( 'edit_quot' ); 
        $presscap->add_cap( 'edit_quots' );
	    $presscap->add_cap( 'edit_other_quots' );
    	$presscap->add_cap( 'edit_private_quots' );
	    $presscap->add_cap( 'edit_published_quots' );
    	$presscap->add_cap( 'read_quot' ); 
    	$presscap->add_cap( 'read_private_quots' );
    	$presscap->add_cap( 'publish_quots' );
    	$presscap->add_cap( 'delete_quot' ); 
        $presscap->add_cap( 'delete_quots' );
    	$presscap->add_cap( 'delete_private_quots' );
    	$presscap->add_cap( 'delete_others_quots' );
    	$presscap->add_cap( 'delete_published_quots' ); 
		
        $presscap->add_cap( 'edit_slide' ); 
        $presscap->add_cap( 'edit_slides' );
	    $presscap->add_cap( 'edit_other_slides' );
    	$presscap->add_cap( 'edit_private_slides' );
	    $presscap->add_cap( 'edit_published_slides' );
    	$presscap->add_cap( 'read_slide' ); 
    	$presscap->add_cap( 'read_private_slides' );
    	$presscap->add_cap( 'publish_slides' );
    	$presscap->add_cap( 'delete_slide' ); 
        $presscap->add_cap( 'delete_slides' );
    	$presscap->add_cap( 'delete_private_slides' );
    	$presscap->add_cap( 'delete_others_slides' );
    	$presscap->add_cap( 'delete_published_slides' ); 
		
        $presscap->add_cap( 'edit_vidio' ); 
        $presscap->add_cap( 'edit_vidios' );
	    $presscap->add_cap( 'edit_other_vidios' );
    	$presscap->add_cap( 'edit_private_vidios' );
	    $presscap->add_cap( 'edit_published_vidios' );
    	$presscap->add_cap( 'read_vidio' ); 
    	$presscap->add_cap( 'read_private_vidios' );
    	$presscap->add_cap( 'publish_vidios' );
    	$presscap->add_cap( 'delete_vidio' ); 
        $presscap->add_cap( 'delete_vidios' );
    	$presscap->add_cap( 'delete_private_vidios' );
    	$presscap->add_cap( 'delete_others_vidios' );
    	$presscap->add_cap( 'delete_published_vidios' ); 
	
}
add_action( 'admin_init', 'add_operator_caps');

function add_ngadimin_caps() {
    
    $presscap = get_role( 'administrator' );
	
	$presscap->add_cap( 'upload_files' );
	
        $presscap->add_cap( 'edit_acara' ); 
        $presscap->add_cap( 'edit_acaras' );
	    $presscap->add_cap( 'edit_other_acaras' );
    	$presscap->add_cap( 'edit_private_acaras' );
	    $presscap->add_cap( 'edit_published_acaras' );
    	$presscap->add_cap( 'read_acara' ); 
    	$presscap->add_cap( 'read_private_acaras' );
    	$presscap->add_cap( 'publish_acaras' );
    	$presscap->add_cap( 'delete_acara' ); 
        $presscap->add_cap( 'delete_acaras' );
    	$presscap->add_cap( 'delete_private_acaras' );
    	$presscap->add_cap( 'delete_others_acaras' );
    	$presscap->add_cap( 'delete_published_acaras' ); 
		
	    $presscap->add_cap( 'edit_blog' ); 
        $presscap->add_cap( 'edit_blogs' );
	    $presscap->remove_cap( 'edit_other_blogs' );
    	$presscap->add_cap( 'edit_private_blogs' );
	    $presscap->add_cap( 'edit_published_blogs' );
    	$presscap->add_cap( 'read_blog' ); 
    	$presscap->add_cap( 'read_private_blogs' );
    	$presscap->add_cap( 'publish_blogs' );
    	$presscap->add_cap( 'delete_blog' ); 
        $presscap->add_cap( 'delete_blogs' );
    	$presscap->add_cap( 'delete_private_blogs' );
    	$presscap->remove_cap( 'delete_others_blogs' );
    	$presscap->add_cap( 'delete_published_blogs' ); 
	
	$presscap->add_cap( 'manage_blogkat' ); 
	$presscap->add_cap( 'assign_blogkat' ); 
	$presscap->add_cap( 'edit_blogkat' ); 
		
        $presscap->add_cap( 'edit_down' ); 
        $presscap->add_cap( 'edit_downs' );
	    $presscap->add_cap( 'edit_other_downs' );
    	$presscap->add_cap( 'edit_private_downs' );
	    $presscap->add_cap( 'edit_published_downs' );
    	$presscap->add_cap( 'read_down' ); 
    	$presscap->add_cap( 'read_private_downs' );
    	$presscap->add_cap( 'publish_downs' );
    	$presscap->add_cap( 'delete_down' ); 
        $presscap->add_cap( 'delete_downs' );
    	$presscap->add_cap( 'delete_private_downs' );
    	$presscap->add_cap( 'delete_others_downs' );
    	$presscap->add_cap( 'delete_published_downs' ); 
		
	$presscap->add_cap( 'manage_catdown' ); 
	$presscap->add_cap( 'assign_catdown' ); 
	$presscap->add_cap( 'edit_catdown' ); 
	
	$presscap->add_cap( 'manage_typedown' ); 
	$presscap->add_cap( 'assign_typedown' ); 
	$presscap->add_cap( 'edit_typedown' ); 
		
if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $presscap->add_cap( 'edit_dosen' ); 
        $presscap->add_cap( 'edit_dosens' );
	    $presscap->add_cap( 'edit_other_dosens' );
    	$presscap->add_cap( 'edit_private_dosens' );
	    $presscap->add_cap( 'edit_published_dosens' );
    	$presscap->add_cap( 'read_dosen' ); 
    	$presscap->add_cap( 'read_private_dosens' );
    	$presscap->add_cap( 'publish_dosens' );
    	$presscap->add_cap( 'delete_dosen' ); 
        $presscap->add_cap( 'delete_dosens' );
    	$presscap->add_cap( 'delete_private_dosens' );
    	$presscap->add_cap( 'delete_others_dosens' );
    	$presscap->add_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $presscap->add_cap( 'edit_ustadz' ); 
        $presscap->add_cap( 'edit_ustadzs' );
	    $presscap->add_cap( 'edit_other_ustadzs' );
    	$presscap->add_cap( 'edit_private_ustadzs' );
	    $presscap->add_cap( 'edit_published_ustadzs' );
    	$presscap->add_cap( 'read_ustadz' ); 
    	$presscap->add_cap( 'read_private_ustadzs' );
    	$presscap->add_cap( 'publish_ustadzs' );
    	$presscap->add_cap( 'delete_ustadz' ); 
        $presscap->add_cap( 'delete_ustadzs' );
    	$presscap->add_cap( 'delete_private_ustadzs' );
    	$presscap->add_cap( 'delete_others_ustadzs' );
    	$presscap->add_cap( 'delete_published_ustadzs' ); 
	} else {
        $presscap->add_cap( 'edit_guru' ); 
        $presscap->add_cap( 'edit_gurus' );
	    $presscap->add_cap( 'edit_other_gurus' );
    	$presscap->add_cap( 'edit_private_gurus' );
	    $presscap->add_cap( 'edit_published_gurus' );
    	$presscap->add_cap( 'read_guru' ); 
    	$presscap->add_cap( 'read_private_gurus' );
    	$presscap->add_cap( 'publish_gurus' );
    	$presscap->add_cap( 'delete_guru' ); 
        $presscap->add_cap( 'delete_gurus' );
    	$presscap->add_cap( 'delete_private_gurus' );
    	$presscap->add_cap( 'delete_others_gurus' );
    	$presscap->add_cap( 'delete_published_gurus' ); 
	}
	
	$presscap->add_cap( 'manage_jab' ); 
	$presscap->add_cap( 'assign_jab' ); 
	$presscap->add_cap( 'edit_jab' ); 
	
	$presscap->add_cap( 'manage_stts' ); 
	$presscap->add_cap( 'assign_stts' ); 
	$presscap->add_cap( 'edit_stts' ); 
		
        $presscap->add_cap( 'edit_editorial' ); 
        $presscap->add_cap( 'edit_editorials' );
	    $presscap->add_cap( 'edit_other_editorials' );
    	$presscap->add_cap( 'edit_private_editorials' );
	    $presscap->add_cap( 'edit_published_editorials' );
    	$presscap->add_cap( 'read_editorial' ); 
    	$presscap->add_cap( 'read_private_editorials' );
    	$presscap->add_cap( 'publish_editorials' );
    	$presscap->add_cap( 'delete_editorial' ); 
        $presscap->add_cap( 'delete_editorials' );
    	$presscap->add_cap( 'delete_private_editorials' );
    	$presscap->add_cap( 'delete_others_editorials' );
    	$presscap->add_cap( 'delete_published_editorials' ); 
		
	if ( get_theme_mod('sekolah_type') != "akademi" ) {
        $presscap->add_cap( 'edit_extra' ); 
        $presscap->add_cap( 'edit_extras' );
	    $presscap->add_cap( 'edit_other_extras' );
    	$presscap->add_cap( 'edit_private_extras' );
	    $presscap->add_cap( 'edit_published_extras' );
    	$presscap->add_cap( 'read_extra' ); 
    	$presscap->add_cap( 'read_private_extras' );
    	$presscap->add_cap( 'publish_extras' );
    	$presscap->add_cap( 'delete_extra' ); 
        $presscap->add_cap( 'delete_extras' );
    	$presscap->add_cap( 'delete_private_extras' );
    	$presscap->add_cap( 'delete_others_extras' );
    	$presscap->add_cap( 'delete_published_extras' ); 
	} else {
        $presscap->add_cap( 'edit_kegiatan' ); 
        $presscap->add_cap( 'edit_kegiatans' );
	    $presscap->add_cap( 'edit_other_kegiatans' );
    	$presscap->add_cap( 'edit_private_kegiatans' );
	    $presscap->add_cap( 'edit_published_kegiatans' );
    	$presscap->add_cap( 'read_kegiatan' ); 
    	$presscap->add_cap( 'read_private_kegiatans' );
    	$presscap->add_cap( 'publish_kegiatans' );
    	$presscap->add_cap( 'delete_kegiatan' ); 
        $presscap->add_cap( 'delete_kegiatans' );
    	$presscap->add_cap( 'delete_private_kegiatans' );
    	$presscap->add_cap( 'delete_others_kegiatans' );
    	$presscap->add_cap( 'delete_published_kegiatans' ); 
	}
        $presscap->add_cap( 'edit_fasil' ); 
        $presscap->add_cap( 'edit_fasils' );
	    $presscap->add_cap( 'edit_other_fasils' );
    	$presscap->add_cap( 'edit_private_fasils' );
	    $presscap->add_cap( 'edit_published_fasils' );
    	$presscap->add_cap( 'read_fasil' ); 
    	$presscap->add_cap( 'read_private_fasils' );
    	$presscap->add_cap( 'publish_fasils' );
    	$presscap->add_cap( 'delete_fasil' ); 
        $presscap->add_cap( 'delete_fasils' );
    	$presscap->add_cap( 'delete_private_fasils' );
    	$presscap->add_cap( 'delete_others_fasils' );
    	$presscap->add_cap( 'delete_published_fasils' ); 
		
        $presscap->add_cap( 'edit_galer' ); 
        $presscap->add_cap( 'edit_galers' );
	    $presscap->add_cap( 'edit_other_galers' );
    	$presscap->add_cap( 'edit_private_galers' );
	    $presscap->add_cap( 'edit_published_galers' );
    	$presscap->add_cap( 'read_galer' ); 
    	$presscap->add_cap( 'read_private_galers' );
    	$presscap->add_cap( 'publish_galers' );
    	$presscap->add_cap( 'delete_galer' ); 
        $presscap->add_cap( 'delete_galers' );
    	$presscap->add_cap( 'delete_private_galers' );
    	$presscap->add_cap( 'delete_others_galers' );
    	$presscap->add_cap( 'delete_published_galers' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $presscap->add_cap( 'edit_maha' ); 
        $presscap->add_cap( 'edit_mahas' );
	    $presscap->add_cap( 'edit_other_mahas' );
    	$presscap->add_cap( 'edit_private_mahas' );
	    $presscap->add_cap( 'edit_published_mahas' );
    	$presscap->add_cap( 'read_maha' ); 
    	$presscap->add_cap( 'read_private_mahas' );
    	$presscap->add_cap( 'publish_mahas' );
    	$presscap->add_cap( 'delete_maha' ); 
        $presscap->add_cap( 'delete_mahas' );
    	$presscap->add_cap( 'delete_private_mahas' );
    	$presscap->add_cap( 'delete_others_mahas' );
    	$presscap->add_cap( 'delete_published_mahas' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $presscap->add_cap( 'edit_santri' ); 
        $presscap->add_cap( 'edit_santris' );
	    $presscap->add_cap( 'edit_other_santris' );
    	$presscap->add_cap( 'edit_private_santris' );
	    $presscap->add_cap( 'edit_published_santris' );
    	$presscap->add_cap( 'read_santri' ); 
    	$presscap->add_cap( 'read_private_santris' );
    	$presscap->add_cap( 'publish_santris' );
    	$presscap->add_cap( 'delete_santri' ); 
        $presscap->add_cap( 'delete_santris' );
    	$presscap->add_cap( 'delete_private_santris' );
    	$presscap->add_cap( 'delete_others_santris' );
    	$presscap->add_cap( 'delete_published_santris' ); 
	} else {
        $presscap->add_cap( 'edit_siswa' ); 
        $presscap->add_cap( 'edit_siswas' );
	    $presscap->add_cap( 'edit_other_siswas' );
    	$presscap->add_cap( 'edit_private_siswas' );
	    $presscap->add_cap( 'edit_published_siswas' );
    	$presscap->add_cap( 'read_siswa' ); 
    	$presscap->add_cap( 'read_private_siswas' );
    	$presscap->add_cap( 'publish_siswas' );
    	$presscap->add_cap( 'delete_siswa' ); 
        $presscap->add_cap( 'delete_siswas' );
    	$presscap->add_cap( 'delete_private_siswas' );
    	$presscap->add_cap( 'delete_others_siswas' );
    	$presscap->add_cap( 'delete_published_siswas' ); 
	}
        $presscap->add_cap( 'edit_peng' ); 
        $presscap->add_cap( 'edit_pengs' );
	    $presscap->add_cap( 'edit_other_pengs' );
    	$presscap->add_cap( 'edit_private_pengs' );
	    $presscap->add_cap( 'edit_published_pengs' );
    	$presscap->add_cap( 'read_peng' ); 
    	$presscap->add_cap( 'read_private_pengs' );
    	$presscap->add_cap( 'publish_pengs' );
    	$presscap->add_cap( 'delete_peng' ); 
        $presscap->add_cap( 'delete_pengs' );
    	$presscap->add_cap( 'delete_private_pengs' );
    	$presscap->add_cap( 'delete_others_pengs' );
    	$presscap->add_cap( 'delete_published_pengs' ); 
		
		$presscap->add_cap( 'edit_prest' ); 
        $presscap->add_cap( 'edit_prests' );
	    $presscap->add_cap( 'edit_other_prests' );
    	$presscap->add_cap( 'edit_private_prests' );
	    $presscap->add_cap( 'edit_published_prests' );
    	$presscap->add_cap( 'read_prest' ); 
    	$presscap->add_cap( 'read_private_prests' );
    	$presscap->add_cap( 'publish_prests' );
    	$presscap->add_cap( 'delete_prest' ); 
        $presscap->add_cap( 'delete_prests' );
    	$presscap->add_cap( 'delete_private_prests' );
    	$presscap->add_cap( 'delete_others_prests' );
    	$presscap->add_cap( 'delete_published_prests' ); 
		
        $presscap->add_cap( 'edit_quot' ); 
        $presscap->add_cap( 'edit_quots' );
	    $presscap->add_cap( 'edit_other_quots' );
    	$presscap->add_cap( 'edit_private_quots' );
	    $presscap->add_cap( 'edit_published_quots' );
    	$presscap->add_cap( 'read_quot' ); 
    	$presscap->add_cap( 'read_private_quots' );
    	$presscap->add_cap( 'publish_quots' );
    	$presscap->add_cap( 'delete_quot' ); 
        $presscap->add_cap( 'delete_quots' );
    	$presscap->add_cap( 'delete_private_quots' );
    	$presscap->add_cap( 'delete_others_quots' );
    	$presscap->add_cap( 'delete_published_quots' ); 
		
        $presscap->add_cap( 'edit_slide' ); 
        $presscap->add_cap( 'edit_slides' );
	    $presscap->add_cap( 'edit_other_slides' );
    	$presscap->add_cap( 'edit_private_slides' );
	    $presscap->add_cap( 'edit_published_slides' );
    	$presscap->add_cap( 'read_slide' ); 
    	$presscap->add_cap( 'read_private_slides' );
    	$presscap->add_cap( 'publish_slides' );
    	$presscap->add_cap( 'delete_slide' ); 
        $presscap->add_cap( 'delete_slides' );
    	$presscap->add_cap( 'delete_private_slides' );
    	$presscap->add_cap( 'delete_others_slides' );
    	$presscap->add_cap( 'delete_published_slides' ); 
		
        $presscap->add_cap( 'edit_vidio' ); 
        $presscap->add_cap( 'edit_vidios' );
	    $presscap->add_cap( 'edit_other_vidios' );
    	$presscap->add_cap( 'edit_private_vidios' );
	    $presscap->add_cap( 'edit_published_vidios' );
    	$presscap->add_cap( 'read_vidio' ); 
    	$presscap->add_cap( 'read_private_vidios' );
    	$presscap->add_cap( 'publish_vidios' );
    	$presscap->add_cap( 'delete_vidio' ); 
        $presscap->add_cap( 'delete_vidios' );
    	$presscap->add_cap( 'delete_private_vidios' );
    	$presscap->add_cap( 'delete_others_vidios' );
    	$presscap->add_cap( 'delete_published_vidios' ); 
		
		$presscap->add_cap( 'edit_tugas' ); 
        $presscap->add_cap( 'edit_tugass' );
	    $presscap->add_cap( 'edit_other_tugass' );
    	$presscap->add_cap( 'edit_private_tugass' );
	    $presscap->add_cap( 'edit_published_tugass' );
    	$presscap->add_cap( 'read_tugas' ); 
    	$presscap->add_cap( 'read_private_tugass' );
    	$presscap->add_cap( 'publish_tugass' );
    	$presscap->add_cap( 'delete_tugas' ); 
        $presscap->add_cap( 'delete_tugass' );
    	$presscap->add_cap( 'delete_private_tugass' );
    	$presscap->add_cap( 'delete_others_tugass' );
    	$presscap->add_cap( 'delete_published_tugass' );
		
	$presscap->add_cap( 'manage_level' ); 
   	$presscap->add_cap( 'assign_level' ); 
	$presscap->add_cap( 'edit_level' );
	$presscap->add_cap( 'manage_mapel' ); 
   	$presscap->add_cap( 'assign_mapel' ); 
	$presscap->add_cap( 'edit_mapel' );
	
}
add_action( 'admin_init', 'add_ngadimin_caps');

?>