<?php
/**
 * Custom WP Prestasi template tags
 * Fungsi pendukung tema WP Prestasi
 */

// Sudah
if ( ! function_exists( 'custom_logo_prestasi' ) ) :
    function custom_logo_prestasi() {
    	if ( function_exists( 'the_custom_logo' ) ) {
			    the_custom_logo();
	    }
    }
endif;
// Sudah
if ( ! function_exists( 'preload_web_font_prestasi' ) ) :
    function preload_web_font_prestasi() {
        get_template_part('header/meta-preload');
	}
endif;
// Sudah
if ( ! function_exists( 'head_meta_property_prestasi' ) ) :
    function head_meta_property_prestasi() {
        get_template_part('header/meta');
	}
endif;
// Sudah
if ( ! function_exists( 'head_meta_desc_prestasi' ) ) :
    function head_meta_desc_prestasi() {
		if (is_front_page()) {
			bloginfo('description');
		} else if (is_singular()) {
			if (function_exists('smart_excerpt')) smart_excerpt(get_the_excerpt(), 60);
		} else {
			echo '';
		}
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_home_slider' ) ) :
    function prestasi_home_slider() {
		if (is_front_page()) {  
	        get_template_part('header/slider');
		}
	}
endif;
// Sudah
if ( ! function_exists( 'slide_time_out' ) ) :
    function slide_time_out() {
		$permile = 1000;
		$perslide = get_theme_mod('slide_timer');
		$time_out_slide = $permile * $perslide;
		if ( get_theme_mod('slide_timer') != "" ) {
	    	echo $time_out_slide; 
		} else {
			echo 6000;
		}
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_get_homepage_top_blocks' ) ) :
	function prestasi_get_homepage_top_blocks() {
		get_template_part('homepage/top-block');
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_get_homepage_quotes' ) ) :
	function prestasi_get_homepage_quotes() {
		get_template_part('homepage/quotes');
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_get_homepage_school_teams' ) ) :
	function prestasi_get_homepage_school_teams() {
		get_template_part('homepage/personel');
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_get_homepage_blog_guru' ) ) :
	function prestasi_get_homepage_blog_guru() {
		get_template_part('homepage/blog');
	}
endif;
// Sudah
if ( ! function_exists( 'prestasi_get_homepage_bot_blocks' ) ) :
	function prestasi_get_homepage_bot_blocks() {
		get_template_part('homepage/bot-block');
	}
endif;

// Sudah
function prestasi_customize_partial_namasekolah() {
	prestasi_nama_sekolah();
}
if ( ! function_exists( 'prestasi_nama_sekolah' ) ) :
	function prestasi_nama_sekolah() {
		if ( get_theme_mod('nama_sekolah') != "" ) {
	    	echo get_theme_mod( 'nama_sekolah'); 
		} else {
			echo __('Sekolahku Keren', 'prestasi');
		}
	}
endif;
// Sudah
function prestasi_customize_partial_address() {
	prestasi_address();
}
if ( ! function_exists( 'prestasi_address' ) ) :
	function prestasi_address() {
		if ( get_theme_mod('address_data') != "" ) {
	        echo get_theme_mod( 'address_data'); 
		} else {
			echo __('Jl. Keren No. 10, Kota Keren, Paling Keren');
		}
	}
endif;
// sudah
function prestasi_customize_partial_nspn() {
	prestasi_nspn();
}
if ( ! function_exists( 'prestasi_nspn' ) ) :
	function prestasi_nspn() {
		if ( get_theme_mod('nspn_data') != "" ) {
	        echo get_theme_mod( 'nspn_data'); 
		} else {
			echo __('00101091');
		}
	}
endif;



		
function prestasi_customize_partial_kepalasekolah() {
	prestasi_kepala_sekolah();
}
if ( ! function_exists( 'prestasi_kepala_sekolah' ) ) :
	function prestasi_kepala_sekolah() {
		if ( get_theme_mod('kepala_sekolah') != "" ) {
	    	echo get_theme_mod( 'kepala_sekolah'); 
		} else {
			echo __( 'Azan Fadli Mulyadi, S.Kom', 'prestasi' ); 
		}
	}
endif;

function prestasi_customize_partial_fotokepala() {
	prestasi_get_photos();
}
if ( ! function_exists( 'prestasi_get_photos' ) ) :
	function prestasi_get_photos() {
		if ( get_theme_mod('foto_kepala') != "" ) {
	    	echo '<img src="'.get_theme_mod( 'foto_kepala').'" />'; 
		} else {
			echo '<img src="'.get_theme_file_uri('images/master.jpg').'" />'; 
		}
	}
endif;

function border_selection() {
	echo '<style type="text/css">'; 
	?>
	    .press_search,
		.info_box h3 span.re_info,
		.press_social .fa,
		.near_agenda h3 span.re_agenda,
		.post_meta span,
		.announ_post h3 span.re_announ,
		.editorial_more a,
		.blog_box h3 span.re_blog,
		.extra_text span.re_lihat,
		.some_input input,
		.some_cat span,
		.kelas_head .to_materi,
		.det_mapel,
		.det_kelas,
		a.login_button,
		a.logout_button,
		.tugas_term span,
		.log_open,
		.log_user,
		.press_cat a,
		.loop_meta span,
		#submit,
		.comment__avatar img,
		.botsearch,
		.botmenu,
		.botclose,
		.closemenu,
		.opensearch .ps_button button,
		.oc_class span:after {
			<? if ( get_theme_mod('box_style') == "bulat" ) { ?>
		    	border-radius: 100px;
			<?php } else if ( get_theme_mod('box_style') == "lengkung" ) { ?>
		    	border-radius: 6px;
			<?php } else { 
	            echo '';
			} ?>
		}
		@media screen and (max-width: 480px) {
		#presslider {
			<? if ( get_theme_mod('box_style') != "bulat" ) { ?>
			    position: relative;
			<?php } else { ?>
		        min-height: 100px;
				width: 100%;
				margin: -200% -50% 0;
				padding: 200% 50% 0;
				overflow: hidden;
				border-radius: 0 0 380px 380px;
	    	<?php } ?>
		}
		.press_infosekolah {
			<? if ( get_theme_mod('box_style') != "bulat" ) { ?>
                position: relative;
			<?php } else { ?>
		        margin: -60px 10px 0 10px;
                border-radius: 0 20px 0 0;
	    	<?php } ?>
        }
        }
		.press_infosekolah {
			<? if ( get_theme_mod('box_style') != "bulat" ) { ?>
		    	border-radius: 0;
			<?php } else { ?>
		    	border-radius: 0 30px 0 0;
	    	<?php } ?>
		}
	
	<?php
	echo '</style>';
}
add_action( 'wp_head', 'border_selection' );

function parallax_breadcrumb() {
	echo '<style type="text/css">'; 
	?>
	.press_page {
		background-image: url(<?php if ( get_theme_mod('bread_parallax') != "" ) {
	    	echo get_theme_mod( 'bread_parallax'); 
		} else {
			echo get_theme_file_uri('image/parallax.jpg');
		} ?>);
	}
	.home_agenda {
		background-image: url(<?php if ( get_theme_mod('bread_parallax') != "" ) {
	    	echo get_theme_mod( 'bread_parallax'); 
		} else {
			echo get_theme_file_uri('image/parallax.jpg');
		} ?>);
	}
	.press_page:after {
		opacity: 0.<?php if ( get_theme_mod('bread_opacity') != "" ) {
	    	echo get_theme_mod( 'bread_opacity'); 
		} else {
			echo 70;
		} ?>;
	}
	<?php
	echo '</style>';
}
add_action( 'wp_head', 'parallax_breadcrumb' );

function prestasi_customize_partial_showmaps() {
	prestasi_school_maps();
}

function prestasi_customize_partial_number() {
	prestasi_school_number();
}
if ( ! function_exists( 'prestasi_school_number' ) ) :
	function prestasi_school_number() {
		if ( get_theme_mod('telpon_data') != "" ) {
			$tel = get_theme_mod('telpon_data'); 
			$new_tel = preg_replace("/[^A-Za-z0-9?!]/",'',$tel);
	    	echo '<a target="_blank" href="tel:'. $new_tel .'">'. get_theme_mod( 'telpon_data' ) .'</a>';
		} else {
			echo '<a target="_blank" href="tel:000000000">'. __( '62 8000 xxx', 'prestasi' ) .'</a>';
		}
	}
endif;

function prestasi_customize_partial_email() {
	prestasi_social_icon();
}
function prestasi_customize_partial_wanumber() {
	prestasi_social_icon();
}
function prestasi_customize_partial_facebook() {
	prestasi_social_icon();
}
function prestasi_customize_partial_twitter() {
	prestasi_social_icon();
}
function prestasi_customize_partial_instagram() {
	prestasi_social_icon();
}
function prestasi_customize_partial_youtube() {
	prestasi_social_icon();
}
if ( ! function_exists( 'prestasi_social_icon' ) ) :
	function prestasi_social_icon() {
		if ( get_theme_mod('facebook_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'facebook_data' ) .'" target="_blank"><i class="fa fa-facebook"></i></a>';
	    }
		if ( get_theme_mod('twitter_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'twitter_data' ) .'" target="_blank"><i class="fa fa-twitter"></i></a>';
	    }
		if ( get_theme_mod('instagram_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'instagram_data' ) .'" target="_blank"><i class="fa fa-instagram"></i></a>';
	    }
		if ( get_theme_mod('youtube_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'youtube_data' ) .'" target="_blank"><i class="fa fa-youtube"></i></a>';
	    }
		if ( get_theme_mod('email_data') != "" ) {
	    	echo '<a target="_blank" href="mailto:'. get_theme_mod('email_data') .'"><i class="fa fa-envelope-o"></i></a>';
		}
		if ( ! prestasi_mobile()) {
			$wa_mode = 'https://web.whatsapp.com';
		} else {
			$wa_mode = 'https://api.whatsapp.com';
		}
		if ( get_theme_mod('wa_data') != "" ) {
			$was = get_theme_mod('wa_data'); 
			$new_was = preg_replace("/[^A-Za-z0-9?!]/",'',$was);
			if ( get_theme_mod('chat_sekolah') != "" ) {
		     	$wa_mess = get_theme_mod('chat_sekolah'); 
	    	} else {
	        	$wa_mess = 'Saya ingin bertanya seputar sekolah ini..'; 
	    	}
	    	echo '<a target="_blank" href="'. $wa_mode .'/send?phone='. $new_was .'&text='. $wa_mess .'"><i class="fa fa-whatsapp"></i></a>';
		} else {
			echo '<a target="_blank" href="'. $wa_mode .'/send?phone="><i class="fa fa-whatsapp"></i></a>';
		}
	}
endif;

if ( ! function_exists( 're_search_download' ) ) :
	function re_search_download() {
		if ( get_theme_mod('re_sedown') != "" ) {
	    	echo html_entity_decode(get_theme_mod( 're_sedown' )); 
		} else {
		    echo __('Hasil Pencarian Akan Muncul Disini', 'prestasi');	
		}
	}
endif;

function prestasi_customize_partial_running() {
	running_text_prestasi();
}
if ( ! function_exists( 'running_text_prestasi' ) ) :
	function running_text_prestasi() {
	    if ( get_theme_mod('running_text') != "" ) {
	        echo '<li>'. get_theme_mod( 'running_text' ) .'</li>'; 
	    } else {
		    echo '<li>'. __( 'Tema Sekolahku Keren Dapat Menampilkan Informasi Dalam Text Berjalan', 'prestasi' ) .'</li>'; 
	    }
	}
endif;	

/* Replace Text
------------------------------- */

function prestasi_customize_partial_reinfo() {
	press_re_info();
}
if ( ! function_exists( 'press_re_info' ) ) :
	function press_re_info() {
		if ( get_theme_mod('re_info') != "" ) { 
		    echo get_theme_mod('re_info');
		} else {
			echo __( 'Info Sekolah', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_rekontak() {
	press_re_kontak();
}
if ( ! function_exists( 'press_re_kontak' ) ) :
	function press_re_kontak() {
		if ( get_theme_mod('re_kontak') != "" ) { 
		    echo get_theme_mod('re_kontak');
		} else {
			echo __( 'Kontak Sekolah', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_reagenda() {
	press_re_agenda();
}
if ( ! function_exists( 'press_re_agenda' ) ) :
	function press_re_agenda() {
		if ( get_theme_mod('re_agenda') != "" ) { 
		    echo get_theme_mod('re_agenda');
		} else {
			echo __( 'Agenda Terbaru', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_reseeagenda() {
	press_resee_agenda();
}
if ( ! function_exists( 'press_resee_agenda' ) ) :
	function press_resee_agenda() {
		if ( get_theme_mod('re_seeagenda') != "" ) { 
		    echo get_theme_mod('re_seeagenda');
		} else {
			echo __( 'Lihat Agenda', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_announ() {
	press_re_announ();
}
if ( ! function_exists( 'press_re_announ' ) ) :
	function press_re_announ() {
		if ( get_theme_mod('re_pengumuman') != "" ) { 
		    echo get_theme_mod('re_pengumuman');
		} else {
			echo __( 'Pengumuman', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_requotes() {
	press_re_quotes();
}
if ( ! function_exists( 'press_re_quotes' ) ) :
	function press_re_quotes() {
		if ( get_theme_mod('re_quotes') != "" ) { 
		    echo get_theme_mod('re_quotes');
		} else {
			echo __( 'Quotes', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_rekepala() {
	press_re_kepala();
}
if ( ! function_exists( 'press_re_kepala' ) ) :
	function press_re_kepala() {
		if ( get_theme_mod('re_kepala') != "" ) { 
		    echo get_theme_mod('re_kepala');
		} else {
			echo __( 'Kepala Sekolah', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_editorial() {
	press_re_editorial();
}
if ( ! function_exists( 'press_re_editorial' ) ) :
	function press_re_editorial() {
		if ( get_theme_mod('re_editorial') != "" ) { 
		    echo get_theme_mod('re_editorial');
		} else {
			echo __( 'Editorial', 'prestasi' );
		}
	}
endif;
function prestasi_customize_partial_editormore() {
	press_re_editormore();
}
if ( ! function_exists( 'press_re_editormore' ) ) :
	function press_re_editormore() {
		if ( get_theme_mod('re_editormore') != "" ) { 
		    echo get_theme_mod('re_editormore');
		} else {
			echo __( 'Read More', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_reguru() {
	press_re_guru();
}
if ( ! function_exists( 'press_re_guru' ) ) :
	function press_re_guru() {
		if ( get_theme_mod('re_guru') != "" ) { 
		    echo get_theme_mod('re_guru');
		} else {
			echo __( 'Daftar Guru', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_reblog() {
	press_re_blog();
}
if ( ! function_exists( 'press_re_blog' ) ) :
	function press_re_blog() {
		if ( get_theme_mod('re_blog') != "" ) { 
		    echo get_theme_mod('re_blog');
		} else {
			echo __( 'Blog Guru', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_refasilitas() {
	press_re_fasilitas();
}
if ( ! function_exists( 'press_re_fasilitas' ) ) :
	function press_re_fasilitas() {
		if ( get_theme_mod('re_fasilitas') != "" ) { 
		    echo get_theme_mod('re_fasilitas');
		} else {
			echo __( 'Fasilitas', 'prestasi' );
		}
	}
endif;		

function prestasi_customize_partial_rekegiatan() {
	press_re_kegiatan();
}
if ( ! function_exists( 'press_re_kegiatan' ) ) :
	function press_re_kegiatan() {
		if ( get_theme_mod('re_kegiatan') != "" ) { 
		    echo get_theme_mod('re_kegiatan');
		} else {
			echo __( 'Kegiatan', 'prestasi' );
		}
	}
endif;	

function prestasi_customize_partial_re_lihat() {
	press_re_lihat();
}
if ( ! function_exists( 'press_re_lihat' ) ) :
	function press_re_lihat() {
		if ( get_theme_mod('re_lihat') != "" ) { 
		    echo get_theme_mod('re_lihat');
		} else {
			echo __( 'Lihat Kegiatan', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_re_galeri() {
	press_re_galeri();
}
if ( ! function_exists( 'press_re_galeri' ) ) :
	function press_re_galeri() {
		if ( get_theme_mod('re_galeri') != "" ) { 
		    echo get_theme_mod('re_galeri');
		} else {
			echo __( 'Galeri', 'prestasi' );
		}
	}
endif;	

function prestasi_customize_partial_re_video() {
	press_re_video();
}
if ( ! function_exists( 'press_re_video' ) ) :
	function press_re_video() {
		if ( get_theme_mod('re_video') != "" ) { 
		    echo get_theme_mod('re_video');
		} else {
			echo __( 'Video', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_renews() {
	press_re_news();
}
if ( ! function_exists( 'press_re_news' ) ) :
	function press_re_news() {
		if ( get_theme_mod('re_news') != "" ) { 
		    echo get_theme_mod('re_news');
		} else {
			echo __( 'Berita Terbaru', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_headnot() {
	prestasi_head_not_found();
}
if ( ! function_exists( 'prestasi_head_not_found' ) ) :
	function prestasi_head_not_found() {
		if ( get_theme_mod('re_head404') != "" ) { 
		    echo get_theme_mod('re_head404');
		} else {
			echo __( '404, Halaman Tidak Ditemukan', 'prestasi' );
		}
	}
endif;

function prestasi_customize_partial_textnot() {
	prestasi_text_not_found();
}
if ( ! function_exists( 'prestasi_text_not_found' ) ) :
	function prestasi_text_not_found() {
		if ( get_theme_mod('re_text404') != "" ) { 
		    echo get_theme_mod('re_text404');
		} else {
			echo __( 'Halaman Ini Tidak Tersedia atau Mungkin Sudah Kadaluarsa', 'prestasi' );
		}
	}
endif;
// Copyright
function prestasi_customize_partial_footcopy() {
	press_text_footer();
}
if ( ! function_exists( 'press_text_footer' ) ) :
	function press_text_footer() {
		if ( get_theme_mod('copy_foot') != "" ) {
			echo get_theme_mod('copy_foot'); 
		} else {
	    	get_template_part('footer/copyright');
		}
	}
endif;

if ( ! function_exists( 'post_related_by_category' ) ) :
	function post_related_by_category() {
		get_template_part('single/related-post');
	}
endif;
if ( ! function_exists( 'post_another_agendas' ) ) :
	function post_another_agendas() {
		get_template_part('single/another-agendas');
	}
endif;
if ( ! function_exists( 'post_another_blogs' ) ) :
	function post_another_blogs() {
		get_template_part('single/another-blogs');
	}
endif;
if ( ! function_exists( 'latest_post_by_gurus' ) ) :
	function latest_post_by_gurus() {
		get_template_part('single/gurus_post');
	}
endif;
if ( ! function_exists( 'post_another_editorials' ) ) :
	function post_another_editorials() {
		get_template_part('single/another-editorials');
	}
endif;
if ( ! function_exists( 'post_another_ekskul' ) ) :
	function post_another_ekskul() {
		get_template_part('single/another-ekskul');
	}
endif;
if ( ! function_exists( 'post_another_fasilitas' ) ) :
	function post_another_fasilitas() {
		get_template_part('single/another-fasilitas');
	}
endif;
if ( ! function_exists( 'post_another_galeri' ) ) :
	function post_another_galeri() {
		get_template_part('single/another-galeri');
	}
endif;
if ( ! function_exists( 'post_another_pengumuman' ) ) :
	function post_another_pengumuman() {
		get_template_part('single/another-pengumuman');
	}
endif;
if ( ! function_exists( 'post_another_prestasi' ) ) :
	function post_another_prestasi() {
		get_template_part('single/another-prestasi');
	}
endif;
if ( ! function_exists( 'post_another_slider' ) ) :
	function post_another_slider() {
		get_template_part('single/another-slider');
	}
endif;
if ( ! function_exists( 'post_another_ukm' ) ) :
	function post_another_ukm() {
		get_template_part('single/another-ukm');
	}
endif;
if ( ! function_exists( 'post_another_video' ) ) :
	function post_another_video() {
		get_template_part('single/another-video');
	}
endif;





?>