<?php 
	
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'agenda',		
	array(			
	    'menu_icon'       => 'dashicons-calendar-alt',
		'labels'          => array(				
	    'name'                => __( 'Agenda' ),				
	    'singular_name'       => __( 'Agenda' ),        
	    'add_new'             => __( 'Tambah Agenda ?' ),	
	    'add_new_item'        => __( 'Tambah Agenda' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Agenda' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Agenda' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Agenda Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Agenda di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),
        'featured_image'      => __( 'Gambar 600 x 400' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor', 'thumbnail'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_acara',
				'edit_posts'                => 'edit_acaras',
                'edit_others_posts'         => 'edit_other_acaras',
				'edit_private_posts'        => 'edit_private_acaras',
				'edit_published_posts'      => 'edit_published_acaras',
				'read_post'                 => 'read_acara',
				'read_private_posts'        => 'read_private_acaras',
				'publish_posts'             => 'publish_acaras',
				'delete_post'               => 'delete_acara',
                'delete_posts'              => 'delete_acaras',
                'delete_private_posts'      => 'delete_private_acaras',
				'delete_others_posts'       => 'delete_others_acaras',
                'delete_published_posts'    => 'delete_published_acaras',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'masevents', 1);
	
	function masevents() {
	    add_meta_box('agenda_events', 'Data Agenda', 'agenda_events', 'agenda', 'normal', 'default');
	}

	function agenda_events() {
	    global $post;
	    echo '<input type="hidden" name="eventmeta_noncename" id="eventmeta_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
        
		$minus = strtotime(get_post_meta($post->ID, '_tevent', true));
	    $tevent = get_post_meta($post->ID, '_tevent', true);
	    $jam = get_post_meta($post->ID, '_jam', true);
		$lokasi = get_post_meta($post->ID, '_lokasi', true);
		$roomaps = get_post_meta($post->ID, '_roomaps', true);
		$hariini = strtotime(date("Y-m-d"));
		$sekarang = strtotime(date("Y-m-d"));
		$currents = $sekarang-$minus;
		?>
		    
		<div class="press_metabox">
		
			<label><?php _e( 'Tanggal Agenda', 'prestasi' ); ?></label>
			<input type="date" name="_tevent" value="<?php echo esc_attr( $tevent ); ?>" class="widefat" />
		
		    <label><?php _e( 'Time (example 08:30 AM)', 'prestasi' ); ?></label>
			<input type="time" name="_jam" value="<?php echo esc_attr( $jam ); ?>" class="widefat" />
			
			<label><?php _e( 'Location', 'prestasi' ); ?></label>
			<input type="text" name="_lokasi" value="<?php echo esc_attr( $lokasi ); ?>" class="widefat" />
			
			<label><?php _e( 'Embed Maps', 'prestasi' ); ?></label>
			<textarea name="_roomaps" class="widefat"><?php echo esc_textarea( $roomaps ); ?></textarea><br/><br/>
			
		</div>
    
	<?php }

	function agenda_events_meta($post_id, $post) {
	    if ( ! isset( $_POST['eventmeta_noncename'] ) || !wp_verify_nonce( $_POST['eventmeta_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }

	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;

		$events_meta['_minus'] = sanitize_text_field(strtotime($_POST['_tevent']));
	    $events_meta['_tevent'] = sanitize_text_field($_POST['_tevent']);
		$events_meta['_jam'] = sanitize_text_field($_POST['_jam']);
		$events_meta['_lokasi'] = sanitize_text_field($_POST['_lokasi']);
		$events_meta['_roomaps'] = sanitize_text_field($_POST['_roomaps']);
		
	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }
	}

	add_action('save_post', 'agenda_events_meta', 1, 2); 
	
?>