<?php
    if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'dosen',		
	array(			
	    'menu_icon'       => 'dashicons-businessperson',
	    'labels'          => array(				
	    'name'                => __( 'Dosen' ),				
	    'singular_name'       => __( 'Dosen' ),        
	    'add_new'             => __( 'Tambah Dosen ?' ),	
	    'add_new_item'        => __( 'Tambah Dosen' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Dosen' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Dosen' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Dosen Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Dosen di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),
        'featured_image'      => __( 'Pas Photo 300 x 400' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_dosen',
				'edit_posts'                => 'edit_dosens',
                'edit_others_posts'         => 'edit_other_dosens',
				'edit_private_posts'        => 'edit_private_dosens',
				'edit_published_posts'      => 'edit_published_dosens',
				'read_post'                 => 'read_dosen',
				'read_private_posts'        => 'read_private_dosens',
				'publish_posts'             => 'publish_dosens',
				'delete_post'               => 'delete_dosen',
                'delete_posts'              => 'delete_dosens',
                'delete_private_posts'      => 'delete_private_dosens',
				'delete_others_posts'       => 'delete_others_dosens',
                'delete_published_posts'    => 'delete_published_dosens',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'guru', 1);
	
	function guru() {
	    add_meta_box('guru_data', 'Biodata Dosen', 'guru_data', 'dosen', 'normal', 'default');
	}

	function guru_data() {
	    global $post;
	    echo '<input type="hidden" name="gtk_noncename" id="gtk_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $nik = get_post_meta($post->ID, '_nik', true);
		$nip = get_post_meta($post->ID, '_nip', true);
		$nuptk = get_post_meta($post->ID, '_nuptk', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$waguru = get_post_meta($post->ID, '_waguru', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$pressfb = get_post_meta($post->ID, '_pressfb', true);
		$presstw = get_post_meta($post->ID, '_presstw', true);
		$pressig = get_post_meta($post->ID, '_pressig', true);
		
		?>

		<div class="press_metabox">
		
		    <label><?php echo __( 'NIDN', 'prestasi' ); ?></label>
	        <input type="text" name="_nik" value="<?php echo esc_attr( $nik ); ?>" class="widefat" />
			
			<label><?php echo __( 'NIY', 'prestasi' ); ?></label>
	        <input type="text" name="_nip" value="<?php echo esc_attr( $nip ); ?>" class="widefat" />
			
			<label><?php echo __( 'NUPTK', 'prestasi' ); ?></label>
			<input type="text" name="_nuptk" value="<?php echo esc_attr( $nuptk ); ?>" class="widefat" />
			
			<label><?php echo __( 'Jenis Kelamin', 'prestasi' ); ?></label>
			<input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tempat Lahir ( Contoh : Ternate )', 'prestasi' ); ?></label>
			<input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tanggal Lahir', 'prestasi' ); ?></label>
			<input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo __( 'Agama : ( Islam, Kristen, Katholik, Hindu, Budha, Konghucu, Lain-Lain )', 'prestasi' ); ?></label>
			<input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo __( 'Alamat', 'prestasi' ); ?></label>
			<input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
			
			<label><?php echo __( 'Telepon', 'prestasi' ); ?></label>
			<input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo __( 'WhatsApp ( Awali Dengan 62 )', 'prestasi' ); ?></label>
			<input type="text" name="_waguru" placeholder="<?php echo __( '62 ...', 'prestasi' ); ?>" value="<?php echo esc_attr( $waguru ); ?>" class="widefat" />
			
			<label><?php echo __( 'Email', 'prestasi' ); ?></label>
			<input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<label><?php echo __( 'Facebook', 'prestasi' ); ?></label>
			<input type="text" name="_pressfb" value="<?php echo esc_attr( $pressfb ); ?>" class="widefat" />
			
			<label><?php echo __( 'Twitter', 'prestasi' ); ?></label>
			<input type="text" name="_presstw" value="<?php echo esc_attr( $presstw ); ?>" class="widefat" />
			
			<label><?php echo __( 'Instagram', 'prestasi' ); ?></label>
			<input type="text" name="_pressig" value="<?php echo esc_attr( $pressig ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function guru_data_meta($post_id, $post) {

	    if ( ! isset( $_POST['gtk_noncename'] ) || !wp_verify_nonce( $_POST['gtk_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }
	    if ( !current_user_can( 'edit_post', $post->ID ))

	        return $post->ID;

	    $pressguru['_nik'] = sanitize_text_field( $_POST['_nik'] );
		$pressguru['_nip'] = sanitize_text_field( $_POST['_nip'] );
		$pressguru['_nuptk'] = sanitize_text_field( $_POST['_nuptk'] );
		$pressguru['_sex'] = sanitize_text_field( $_POST['_sex'] );
		$pressguru['_tmpt'] = sanitize_text_field( $_POST['_tmpt'] );
		$pressguru['_tgl'] = sanitize_text_field( $_POST['_tgl'] );
		$pressguru['_rel'] = sanitize_text_field( $_POST['_rel'] );
		$pressguru['_add'] = sanitize_text_field( $_POST['_add'] );
		$pressguru['_telp'] = sanitize_text_field( $_POST['_telp'] );
		$pressguru['_waguru'] = sanitize_text_field( $_POST['_waguru'] );
		$pressguru['_mail'] = sanitize_text_field( $_POST['_mail'] );
		$pressguru['_pressfb'] = sanitize_text_field( $_POST['_pressfb'] );
		$pressguru['_presstw'] = sanitize_text_field( $_POST['_presstw'] );
		$pressguru['_pressig'] = sanitize_text_field( $_POST['_pressig'] );
		
	    foreach ($pressguru as $key => $value) {        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); // 
	    }

	}

	add_action('save_post', 'guru_data_meta', 1, 2); 
	
	// Start Education
	
	add_action('admin_init', 'guru_education', 1);
	function guru_education() {
    	add_meta_box( 'education', 'Riwayat Pendidikan', 'edu_input', 'dosen', 'normal', 'default');
    }

	function edu_input() {
    	global $post;
    	$edu_guru = get_post_meta($post->ID, 'edu_guru', true);
    	wp_nonce_field( 'edu_gurumeta', 'edu_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-edu' ).on('click', function() {
			var row = $( '.emptyedu.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyedu screen-reader-text' );
			row.insertBefore( '#edulisting tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-edu' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
        
		<div class="press_metabox">
        	<table id="edulisting">
		    
		    	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo __( 'Pendidikan', 'prestasi' ); ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo __( 'Tahun', 'prestasi' ); ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $edu_guru ) :
			foreach ( $edu_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduname[]" value="<?php if($field['eduname'] != '') echo esc_attr( $field['eduname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduyear[]" value="<?php if ($field['eduyear'] != '') echo esc_attr( $field['eduyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyedu screen-reader-text">
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
		    </table>
		</div>
		
		<div class="press_metabox"><a id="add-edu" class="button button-primary button-large" href="#"><?php echo __( 'Tambah Baru', 'prestasi' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'edu_metasave');

	function edu_metasave($post_id) {
    	if ( ! isset( $_POST['edu_gurumeta'] ) ||
        	! wp_verify_nonce( $_POST['edu_gurumeta'], 'edu_gurumeta' ) )
	    	return;
	    
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'edu_guru', true);
    	$news = array();
	
    	$edunames = $_POST['eduname'];
    	$eduyears = $_POST['eduyear'];
	
    	$counts = count( $edunames );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $edunames[$i] != '' ) {
	    		$news[$i]['eduname'] = stripslashes( strip_tags( $edunames[$i] ) );
				$news[$i]['eduyear'] = stripslashes( strip_tags( $eduyears[$i] ) ); 
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'edu_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'edu_guru', $olds );
	}	
    
	// End Education
	
	// Start Work History
	
	add_action('admin_init', 'guru_history', 1);
	
	function guru_history() {
    	add_meta_box( 'historial', 'Riwayat Pekerjaan', 'his_input', 'dosen', 'normal', 'default');
    }

	function his_input() {
    	global $post;
    	$his_guru = get_post_meta($post->ID, 'his_guru', true);
    	wp_nonce_field( 'his_gurumeta', 'his_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-his' ).on('click', function() {
			var row = $( '.emptyhis.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyhis screen-reader-text' );
			row.insertBefore( '#hislisting tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-his' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
  
    	<div class="press_metabox">
    		<table id="hislisting">
		    
		    	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo __( 'Pekerjaan', 'prestasi' ); ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo __( 'Tahun Kerja', 'prestasi' ); ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $his_guru ) :
			foreach ( $his_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisname[]" value="<?php if($field['hisname'] != '') echo esc_attr( $field['hisname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisyear[]" value="<?php if ($field['hisyear'] != '') echo esc_attr( $field['hisyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyhis screen-reader-text">
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo __( 'Hapus', 'prestasi' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
	    	</table>
		</div>
		
		<div class="press_metabox"><a id="add-his" class="button button-primary button-large" href="#"><?php echo __( 'Tambah Baru', 'prestasi' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'his_metasave');

	function his_metasave($post_id) {
    	if ( ! isset( $_POST['his_gurumeta'] ) ||
        	! wp_verify_nonce( $_POST['his_gurumeta'], 'his_gurumeta' ) )
	    	return;
	
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'his_guru', true);
    	$news = array();
	
    	$hisnames = $_POST['hisname'];
    	$hisyears = $_POST['hisyear'];
	
    	$counts = count( $hisnames );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $hisnames[$i] != '' ) {
	    		$news[$i]['hisname'] = stripslashes( strip_tags( $hisnames[$i] ) );
				$news[$i]['hisyear'] = stripslashes( strip_tags( $hisyears[$i] ) ); 
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'his_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'his_guru', $olds );
	}	
    
	// End Work History
	
?>