<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'mahasiswa',		
	array(			
	    'menu_icon' => 'dashicons-buddicons-buddypress-logo',
	    'labels'          => array(				
	    'name'                => __( 'Mahasiswa' ),				
	    'singular_name'       => __( 'Mahasiswa' ),        
	    'add_new'             => __( 'Tambah Mahasiswa ?' ),	
	    'add_new_item'        => __( 'Tambah Mahasiswa' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Mahasiswa' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Mahasiswa' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Mahasiswa Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Mahasiswa di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),
        'featured_image'      => __( 'Pas Photo 300 x 400' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_maha',
				'edit_posts'                => 'edit_mahas',
                'edit_others_posts'         => 'edit_other_mahas',
				'edit_private_posts'        => 'edit_private_mahas',
				'edit_published_posts'      => 'edit_published_mahas',
				'read_post'                 => 'read_maha',
				'read_private_posts'        => 'read_private_mahas',
				'publish_posts'             => 'publish_mahas',
				'delete_post'               => 'delete_maha',
                'delete_posts'              => 'delete_mahas',
                'delete_private_posts'      => 'delete_private_mahas',
				'delete_others_posts'       => 'delete_others_mahas',
                'delete_published_posts'    => 'delete_published_mahas',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'mhs', 1);
	function mhs() {
	    add_meta_box('mhs_data', 'Biodata Mahasiswa', 'mhs_data', 'mahasiswa', 'normal', 'default');
	}

	function mhs_data() {
	    global $post;
	    echo '<input type="hidden" name="eventmeta_noncename" id="eventmeta_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $mas = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="press_metabox">
		
		    <label><?php echo __( 'Mulai Masuk Kampus', 'prestasi' ); ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo __( 'NIM', 'prestasi' ); ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo __( 'Jenis Kelamin', 'prestasi' ); ?></label>
	        <input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tempat Lahir', 'prestasi' ); ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tanggal Lahir', 'prestasi' ); ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo __( 'Agama', 'prestasi' ); ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo __( 'Alamat', 'prestasi' ); ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo __( 'Telpon', 'prestasi' ); ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo __( 'Email', 'prestasi' ); ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo __( 'Anak Ke', 'prestasi' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo __( 'Dari Berapa Bersaudara ?', 'prestasi' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo __( 'Nama Ayah', 'prestasi' ); ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo __( 'Nama Ibu', 'prestasi' ); ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <label><?php echo __( 'Alamat Orang Tua', 'prestasi' ); ?></label>
	        <input type="date" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function mhs_data_meta($post_id, $post) {

	    if ( !isset( $_POST['eventmeta_noncename'] ) || !wp_verify_nonce( $_POST['eventmeta_noncename'], plugin_basename(__FILE__) )) {
            return $post->ID;
        }
	    if ( !current_user_can( 'edit_post', $post->ID ))

	        return $post->ID;

	    $mahasiswa['_mas'] = sanitize_text_field( $_POST['_mas'] );
		$mahasiswa['_nisn'] = sanitize_text_field( $_POST['_nisn'] );
		$mahasiswa['_sex'] = sanitize_text_field( $_POST['_sex'] );
		$mahasiswa['_tmpt'] = sanitize_text_field( $_POST['_tmpt'] );
		$mahasiswa['_tgl'] = sanitize_text_field( $_POST['_tgl'] );
		$mahasiswa['_rel'] = sanitize_text_field( $_POST['_rel'] );
		$mahasiswa['_add'] = sanitize_text_field( $_POST['_add'] );
		$mahasiswa['_telp'] = sanitize_text_field( $_POST['_telp'] );
		$mahasiswa['_mail'] = sanitize_text_field( $_POST['_mail'] );
		$mahasiswa['_anak'] = sanitize_text_field( $_POST['_anak'] );
		$mahasiswa['_dari'] = sanitize_text_field( $_POST['_dari'] );
		$mahasiswa['_ayah'] = sanitize_text_field( $_POST['_ayah'] );
		$mahasiswa['_ibu'] = sanitize_text_field( $_POST['_ibu'] );
		
	    foreach ($mahasiswa as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }

	}

	add_action('save_post', 'mhs_data_meta', 1, 2); 
	
	add_action( 'init', 'mhs_fakultas', 0 );
	function mhs_fakultas() {
	    $labels = array(
    	    'name'              => __( 'Fakultas / Semester' ),
	        'singular_name'     => __( 'Fakultas / Semester' ),
	        'search_items'      => __( 'Cari ...' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Fakultas / Semester' ),
	    );   
	  
	    register_taxonomy('fakultas',array('mahasiswa'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Ekonomi Sementer 4',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
	  ));
	}
	
?>