<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'materi',		
	array(			
	    'menu_icon' => 'dashicons-clipboard',
	    'labels'          => array(				
	    'name'                => __( 'Materi + Tugas' ),				
	    'singular_name'       => __( 'Materi + Tugas' ),        
	    'add_new'             => __( 'Tambah Materi ?' ),	
	    'add_new_item'        => __( 'Tambah Materi' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Materi' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Materi' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Materi Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Materi di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),	
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor',),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => false,
			'capabilities' => array(
                'edit_post'                 => 'edit_tugas',
				'edit_posts'                => 'edit_tugass',
                'edit_others_posts'         => 'edit_other_tugass',
				'edit_private_posts'        => 'edit_private_tugass',
				'edit_published_posts'      => 'edit_published_tugass',
				'read_post'                 => 'read_tugas',
				'read_private_posts'        => 'read_private_tugass',
				'publish_posts'             => 'publish_tugass',
				'delete_post'               => 'delete_tugas',
                'delete_posts'              => 'delete_tugass',
                'delete_private_posts'      => 'delete_private_tugass',
				'delete_others_posts'       => 'delete_others_tugass',
                'delete_published_posts'    => 'delete_published_tugass',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'materi_timer', 1);
	
	function materi_timer() {
	    add_meta_box('timer', 'Materi Kadaluarsa', 'materi_expired', 'materi', 'normal', 'default');
	}

	function materi_expired() {
	    global $post;
	    echo '<input type="hidden" name="eventmeta_noncename" id="eventmeta_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
        
	    $matdate = get_post_meta($post->ID, 'matdate', true);
	    $mattime = get_post_meta($post->ID, 'mattime', true);
		
	    $showdate = get_post_meta($post->ID, 'showdate', true);
	    $showtime = get_post_meta($post->ID, 'showtime', true);
		
		?>
		    
		<div class="press_metabox">
		
		    <p><?php _e('Atur Tanggal Batas Materi Untuk Disembunyikan Kepada Siswa'); ?></p>
		
			<label><?php _e( 'Tanggal', 'prestasi' ); ?></label>
			<input type="date" name="matdate" value="<?php echo esc_attr( $matdate ); ?>" class="widefat" />
		
		    <label><?php _e( 'Waktu ', 'prestasi' ); ?></label>
			<input type="time" name="mattime" value="<?php echo esc_attr( $mattime ); ?>" class="widefat" />
			
			<p><?php _e('Atur Tanggal Materi Untuk Dimunculkan Kembali'); ?></p>
		
			<label><?php _e( 'Tanggal', 'prestasi' ); ?></label>
			<input type="date" name="showdate" value="<?php echo esc_attr( $showdate ); ?>" class="widefat" />
		
		    <label><?php _e( 'Waktu ', 'prestasi' ); ?></label>
			<input type="time" name="showtime" value="<?php echo esc_attr( $showtime ); ?>" class="widefat" />
			
		</div>
    
	<?php }

	function materi_timer_meta($post_id, $post) {
	    if ( ! isset( $_POST['eventmeta_noncename'] ) || !wp_verify_nonce( $_POST['eventmeta_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }

	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;

		$events_meta['matdate'] = sanitize_text_field($_POST['matdate']);
	    $events_meta['mattime'] = $_POST['mattime'];
		$events_meta['showdate'] = sanitize_text_field($_POST['showdate']);
	    $events_meta['showtime'] = $_POST['showtime'];
		
	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }
	}

	add_action('save_post', 'materi_timer_meta', 1, 2); 
	
	
	// Start Materi
	
	add_action('admin_init', 'materi_tugas', 1);
	
	function materi_tugas() {
    	add_meta_box( 'boxmateri', 'Buat Materi Tugas', 'add_materi', 'materi', 'normal', 'default');
    }

	function add_materi() {
    	global $post;
    	$materi_soal = get_post_meta($post->ID, 'materi_soal', true);
    	wp_nonce_field( 'materi_soalmeta', 'materi_soalmeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-his' ).on('click', function() {
			var row = $( '.emptysoal.screen-reader-text' ).clone(true);
			row.removeClass( 'emptysoal screen-reader-text' );
			row.insertBefore( '#listingsoal tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-soal' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
  
    	<div class="press_metabox">
    		<table id="listingsoal">
		    
			
         	<?php if ( $materi_soal ) :
			foreach ( $materi_soal as $field ) { ?>
             	<tr>
            		<td>
					    <div class="clear">
						    <div class="full">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo __('Buat Pertanyaan Dikolom Ini ...', 'prestasi'); ?>" class="widefat" name="question[]" value="<?php if($field['question'] != '') echo esc_attr( $field['question'] ); ?>" />
								</div>
							</div>
						</div>
						<div class="clear">
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo __('Jawaban A', 'prestasi'); ?>" class="widefat" name="answer1[]" value="<?php if ($field['answer1'] != '') echo esc_attr( $field['answer1'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo __('Jawaban B', 'prestasi'); ?>" class="widefat" name="answer2[]" value="<?php if ($field['answer2'] != '') echo esc_attr( $field['answer2'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo __('Jawaban C', 'prestasi'); ?>" class="widefat" name="answer3[]" value="<?php if ($field['answer3'] != '') echo esc_attr( $field['answer3'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo __('Jawaban D', 'prestasi'); ?>" class="widefat" name="answer4[]" value="<?php if ($field['answer4'] != '') echo esc_attr( $field['answer4'] ); ?>" />
								</div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo __( 'Hapus Soal', 'prestasi' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="clear">
						    <div class="full">
							    <div class="halfin">
			    	            	<input type="text" placeholder="<?php echo __('Buat Pertanyaan Dikolom Ini ...', 'prestasi'); ?>" class="widefat" name="question[]" />
								</div>
							</div>
						</div>
						<div class="clear">
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban A', 'prestasi'); ?>" class="widefat" name="answer1[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban B', 'prestasi'); ?>" class="widefat" name="answer2[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban C', 'prestasi'); ?>" class="widefat" name="answer3[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban D', 'prestasi'); ?>" class="widefat" name="answer4[]" />
							    </div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo __( 'Hapus Soal', 'prestasi' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptysoal screen-reader-text">
            		<td>
					    <div class="clear">
						    <div class="full">
							    <div class="halfin">
			    	            	<input type="text" placeholder="<?php echo __('Buat Pertanyaan Dikolom Ini ...', 'prestasi'); ?>" class="widefat" name="question[]" />
								</div>
							</div>
						</div>
						<div class="clear">
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban A', 'prestasi'); ?>" class="widefat" name="answer1[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban B', 'prestasi'); ?>" class="widefat" name="answer2[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban C', 'prestasi'); ?>" class="widefat" name="answer3[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo __('Jawaban D', 'prestasi'); ?>" class="widefat" name="answer4[]" />
							    </div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo __( 'Hapus Soal', 'prestasi' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
	    	</table>
		</div>
		
		<div class="press_metabox"><a id="add-his" class="button button-primary button-large" href="#"><?php echo __( 'Tambah Soal', 'prestasi' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'save_materi');

	function save_materi($post_id) {
    	if ( ! isset( $_POST['materi_soalmeta'] ) ||
        	! wp_verify_nonce( $_POST['materi_soalmeta'], 'materi_soalmeta' ) )
	    	return;
	
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'materi_soal', true);
    	$news = array();
	
    	$questions = $_POST['question'];
    	$answer1s  = $_POST['answer1'];
		$answer2s  = $_POST['answer2'];
		$answer3s  = $_POST['answer3'];
		$answer4s  = $_POST['answer4'];
	
    	$counts = count( $questions );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $questions[$i] != '' ) {
	    		$news[$i]['question'] = stripslashes( strip_tags( $questions[$i] ) );
				$news[$i]['answer1']  = stripslashes( strip_tags( $answer1s[$i] ) ); 
				$news[$i]['answer2']  = stripslashes( strip_tags( $answer2s[$i] ) ); 
				$news[$i]['answer3']  = stripslashes( strip_tags( $answer3s[$i] ) ); 
				$news[$i]['answer4']  = stripslashes( strip_tags( $answer4s[$i] ) ); 
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'materi_soal', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'materi_soal', $olds );
	}	
    
	// End Work History
	

?>