<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'prestasi',		
	array(			
	    'menu_icon'       => 'dashicons-heart',
	    'labels'          => array(				
	    'name'                => __( 'Prestasi' ),				
	    'singular_name'       => __( 'Prestasi' ),        
	    'add_new'             => __( 'Tambah Prestasi ?' ),	
	    'add_new_item'        => __( 'Tambah Prestasi' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Prestasi' ),	
	    'new_item'            => __( 'Item Prestasi' ),	
	    'view'                => __( 'Lihat Prestasi' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Prestasi Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Prestasi di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),		
        'featured_image'      => __( 'Gambar Unggulan' ),		
	    ),		                	
	    	'public'              => true,           					            
	    	'has_archive'         => true,        			            
	    	'supports'            => array( 'title', 'editor', 'thumbnail' ),        			            
	    	'exclude_from_search' => false,
			'show_in_rest'        => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_prest',
				'edit_posts'                => 'edit_prests',
                'edit_others_posts'         => 'edit_other_prests',
				'edit_private_posts'        => 'edit_private_prests',
				'edit_published_posts'      => 'edit_published_prests',
				'read_post'                 => 'read_prest',
				'read_private_posts'        => 'read_private_prests',
				'publish_posts'             => 'publish_prests',
				'delete_post'               => 'delete_prest',
                'delete_posts'              => 'delete_prests',
                'delete_private_posts'      => 'delete_private_prests',
				'delete_others_posts'       => 'delete_others_prests',
                'delete_published_posts'    => 'delete_published_prests',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'pres', 1);
	function pres() {
	    add_meta_box('sch_pres', 'Peraih Prestasi', 'sch_pres', 'prestasi', 'normal', 'default');
	}

	function sch_pres() {
	    global $post;
	    echo '<input type="hidden" name="prestasi_noncename" id="prestasi_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $peraih = get_post_meta($post->ID, '_peraih', true);
		?>
		
		<div class="press_metabox">
		
			<label><?php echo __(' Tuliskan Nama atau Grup Yang Mewakili, Misalkan : <strong>Azan Fadli Mulyadi</strong> atau <strong>Team Bulu Tangkis</strong>','prestasi' ); ?></label>
	        <input type="text" name="_peraih" value="<?php echo esc_attr( $peraih ); ?>" class="widefat" />
		
		</div>
		
	<?php }

	function pres_meta($post_id, $post) {
	    if ( ! isset( $_POST['prestasi_noncename'] ) || !wp_verify_nonce( $_POST['prestasi_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }

	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
			
	    $events_meta['_peraih'] = sanitize_text_field( $_POST['_peraih'] );

	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key);
	    }

	}

	add_action('save_post', 'pres_meta', 1, 2); 
?>