<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'siswa',		
	array(			
	    'menu_icon' => 'dashicons-buddicons-buddypress-logo',
	    'labels'          => array(				
	    'name'                => __( 'Siswa' ),				
	    'singular_name'       => __( 'Siswa' ),        
	    'add_new'             => __( 'Tambah Siswa ?' ),	
	    'add_new_item'        => __( 'Tambah Siswa' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Siswa' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Siswa' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Siswa Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Siswa di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),
        'featured_image'      => __( 'Pas Photo 300 x 400' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_siswa',
				'edit_posts'                => 'edit_siswas',
                'edit_others_posts'         => 'edit_other_siswas',
				'edit_private_posts'        => 'edit_private_siswas',
				'edit_published_posts'      => 'edit_published_siswas',
				'read_post'                 => 'read_siswa',
				'read_private_posts'        => 'read_private_siswas',
				'publish_posts'             => 'publish_siswas',
				'delete_post'               => 'delete_siswa',
                'delete_posts'              => 'delete_siswas',
                'delete_private_posts'      => 'delete_private_siswas',
				'delete_others_posts'       => 'delete_others_siswas',
                'delete_published_posts'    => 'delete_published_siswas',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'sis_meta', 1);
	function sis_meta() {
	    add_meta_box('sis_data', 'Biodata Siswa', 'sis_data', 'siswa', 'normal', 'default');
	}

	function sis_data() {
	    global $post;
	    echo '<input type="hidden" name="siswa_noncename" id="siswa_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $mas = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="press_metabox">
		
		    <label><?php echo __( 'Mulai Masuk Sekolah', 'prestasi' ); ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo __( 'NISN', 'prestasi' ); ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo __( 'Jenis Kelamin', 'prestasi' ); ?></label>
	        <input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tempat Lahir', 'prestasi' ); ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo __( 'Tanggal Lahir', 'prestasi' ); ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo __( 'Agama', 'prestasi' ); ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo __( 'Alamat', 'prestasi' ); ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo __( 'Telpon', 'prestasi' ); ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo __( 'Email', 'prestasi' ); ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo __( 'Anak Ke', 'prestasi' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo __( 'Dari Berapa Bersaudara ?', 'prestasi' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo __( 'Nama Ayah', 'prestasi' ); ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo __( 'Nama Ibu', 'prestasi' ); ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <label><?php echo __( 'Alamat Orang Tua', 'prestasi' ); ?></label>
	        <input type="date" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function sis_data_meta($post_id, $post) {

	    if ( !isset( $_POST['siswa_noncename'] ) || !wp_verify_nonce( $_POST['siswa_noncename'], plugin_basename(__FILE__) )) {
            return $post->ID;
        }
	    if ( !current_user_can( 'edit_post', $post->ID ))

	        return $post->ID;

	    $santri['_mas'] = sanitize_text_field( $_POST['_mas'] );
		$santri['_nisn'] = sanitize_text_field( $_POST['_nisn'] );
		$santri['_sex'] = sanitize_text_field( $_POST['_sex'] );
		$santri['_tmpt'] = sanitize_text_field( $_POST['_tmpt'] );
		$santri['_tgl'] = sanitize_text_field( $_POST['_tgl'] );
		$santri['_rel'] = sanitize_text_field( $_POST['_rel'] );
		$santri['_add'] = sanitize_text_field( $_POST['_add'] );
		$santri['_telp'] = sanitize_text_field( $_POST['_telp'] );
		$santri['_mail'] = sanitize_text_field( $_POST['_mail'] );
		$santri['_anak'] = sanitize_text_field( $_POST['_anak'] );
		$santri['_dari'] = sanitize_text_field( $_POST['_dari'] );
		$santri['_ayah'] = sanitize_text_field( $_POST['_ayah'] );
		$santri['_ibu'] = sanitize_text_field( $_POST['_ibu'] );
		
	    foreach ($santri as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }

	}

	add_action('save_post', 'sis_data_meta', 1, 2); 
	
?>