<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
    if ( get_theme_mod('slide_width') != "" ) {
		$swidth = get_theme_mod('slide_width');
	} else {
		$swidth = 1200;
	}
	if ( get_theme_mod('slide_height') != "" ) {
		$sheight = get_theme_mod('slide_height');
	} else {
		$sheight = 700;
	}
	register_post_type( 'slider',		
	array(			
	    'menu_icon'       => 'dashicons-images-alt2',
		'labels'          => array(				
	    'name'                => __( 'Slide Gambar' ),				
	    'singular_name'       => __( 'Slide Gambar' ),        
	    'add_new'             => __( 'Tambah Slide ?' ),	
	    'add_new_item'        => __( 'Tambah Slide' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Slide' ),	
	    'new_item'            => __( 'Item Slide' ),	
	    'view'                => __( 'Lihat Slide' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Slide Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Slide di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),		
        'featured_image'      => __( 'Gambar '.$swidth.' x '.$sheight.'', 'wpsekolah' ),		
	    ),		                	
	    	'public'              => true,           					            
	    	'has_archive'         => true,        			            
	    	'supports'            => array( 'title', 'editor', 'thumbnail' ),        			            
	    	'exclude_from_search' => false,
			'show_in_rest'        => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_slide',
				'edit_posts'                => 'edit_slides',
                'edit_others_posts'         => 'edit_other_slides',
				'edit_private_posts'        => 'edit_private_slides',
				'edit_published_posts'      => 'edit_published_slides',
				'read_post'                 => 'read_slide',
				'read_private_posts'        => 'read_private_slides',
				'publish_posts'             => 'publish_slides',
				'delete_post'               => 'delete_slide',
                'delete_posts'              => 'delete_slides',
                'delete_private_posts'      => 'delete_private_slides',
				'delete_others_posts'       => 'delete_others_slides',
                'delete_published_posts'    => 'delete_published_slides',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	// Link Slider Metabox
    add_action('admin_init', 'slider_link', 1);
	
	function slider_link() {
	    add_meta_box('extlink', 'Link Eksternal', 'extlink', 'slider', 'normal', 'default');
	}

	function extlink() {
	    global $post;
	    echo '<input type="hidden" name="slide_noncename" id="slide_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $extlink = get_post_meta($post->ID, '_extlink', true);
		?>
		
		<div class="press_metabox">
		    
			<label><?php echo __( 'Masukan Tautan / Link Jika Ingin Slider Mengarah Pada Halaman Tertentu', 'prestasi' ); ?></label>
			<input type="text" name="_extlink" value="<?php echo esc_attr( $extlink ); ?>" class="widefat" />
			
		</div>
		
	<?php }

	function sliderlink_meta($post_id, $post) {
	    if ( ! isset( $_POST['slide_noncename'] ) || !wp_verify_nonce( $_POST['slide_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }

	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
		
		$events_meta['_extlink'] = sanitize_text_field( $_POST['_extlink'] );

	    foreach ($events_meta as $key => $value) {      
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }

	}
	add_action('save_post', 'sliderlink_meta', 1, 2); 

?>