<?php

	add_action( 'init', 'presscat_blog', 0 );
	function presscat_blog() {
	    $labels = array(
    	    'name'              => __( 'Kategori Blog' ),
	        'singular_name'     => __( 'Kategori Blog' ),
	        'search_items'      => __( 'Cari Kategori' ),
    	    'all_items'         => __( 'Semua Kategori' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Kategori' ),
    	    'update_item'       => __( 'Update Kategori' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Kategori Baru' ),
    	    'menu_name'         => __( 'Kategori Blog' ),
	    );   
	  
	    register_taxonomy('blog-kat',array('blog'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Sekolah',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_blogkat',
                'edit_terms'    => 'edit_blogkat',
                'delete_terms'  => 'delete_blogkat',
                'assign_terms'  => 'assign_blogkat',
            )
	  ));
	}
	
	add_action( 'init', 'status_guru', 0 );
	function status_guru() {
	    $labels = array(
    	    'name'              => __( 'Status Kepegawaian' ),
	        'singular_name'     => __( 'Status Kepegawaian' ),
	        'search_items'      => __( 'Cari Status' ),
    	    'all_items'         => __( 'Semua Status' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Status' ),
    	    'update_item'       => __( 'Update Status' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Status Baru' ),
    	    'menu_name'         => __( 'Status' ),
	    );   
	  
	    register_taxonomy('stts',array('gtk','ustadz','dosen'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'PNS',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_stts',
                'edit_terms'    => 'edit_stts',
                'delete_terms'  => 'delete_stts',
                'assign_terms'  => 'assign_stts',
            )
	  ));
	}
	
	add_action( 'init', 'jenis_guru', 0 );
	function jenis_guru() {
	    $labels = array(
    	    'name'              => __( 'Jabatan Fungsional' ),
	        'singular_name'     => __( 'Jabatan Fungsional' ),
	        'search_items'      => __( 'Cari Jabatan' ),
    	    'all_items'         => __( 'Semua Jabatan' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Jabatan' ),
    	    'update_item'       => __( 'Update Jabatan' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Jabatan Baru' ),
    	    'menu_name'         => __( 'Jabatan' ),
	    );   
	  
	    register_taxonomy('jab',array('gtk','ustadz','dosen'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Guru Kelas 10',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_jab',
                'edit_terms'    => 'edit_jab',
                'delete_terms'  => 'delete_jab',
                'assign_terms'  => 'assign_jab',
            )
	  ));
	}
	add_action( 'init', 'siswa_kelas', 0 );
	function siswa_kelas() {
	    $labels = array(
    	    'name'              => __( 'Kelas / Jurusan' ),
	        'singular_name'     => __( 'Kelas / Jurusan' ),
	        'search_items'      => __( 'Cari..' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Kelas / Jurusan' ),
	    );   
	  
	    register_taxonomy('kelas',array('siswa', 'santri'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Kelas 10',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
	  ));
	}

	add_action( 'init', 'cat_download', 0 );
	function cat_download() {
	    $labels = array(
    	    'name'              => __( 'Kategori Download' ),
	        'singular_name'     => __( 'Kategori Download' ),
	        'search_items'      => __( 'Cari..' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Kategori Download' ),
	    );   
	  
	    register_taxonomy('cat-download',array('download'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Kelas 10',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_catdown',
                'edit_terms'    => 'edit_catdown',
                'delete_terms'  => 'delete_catdown',
                'assign_terms'  => 'assign_catdown',
            )
	  ));
	}
	add_action( 'init', 'type_download', 0 );
	function type_download() {
	    $labels = array(
    	    'name'              => __( 'Type File Download' ),
	        'singular_name'     => __( 'Type File Download' ),
	        'search_items'      => __( 'Cari..' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Type File Download' ),
	    );   
	  
	    register_taxonomy('type-file',array('download'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'PDF',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_typedown',
                'edit_terms'    => 'edit_typedown',
                'delete_terms'  => 'delete_typedown',
                'assign_terms'  => 'assign_typedown',
            )
	  ));
	}
	
	add_action( 'init', 'materi_kelas', 0 );
	function materi_kelas() {
	    $labels = array(
    	    'name'              => __( 'Kelas / Jurusan' ),
	        'singular_name'     => __( 'Kelas / Jurusan' ),
	        'search_items'      => __( 'Cari..' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Kelas / Jurusan' ),
	    );   
	  
	    register_taxonomy('tugas',array('materi'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Kelas 10',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_level',
                'edit_terms'    => 'edit_level',
                'delete_terms'  => 'delete_level',
                'assign_terms'  => 'assign_level',
            )
	  ));
	}
	
	add_action( 'init', 'materi_mapel', 0 );
	function materi_mapel() {
	    $labels = array(
    	    'name'              => __( 'Mata Pelajaran' ),
	        'singular_name'     => __( 'Mata Pelajaran' ),
	        'search_items'      => __( 'Cari..' ),
    	    'all_items'         => __( 'Semua Data' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Data' ),
    	    'update_item'       => __( 'Update Data' ),
    	    'add_new_item'      => __( 'Tambah Baru' ),
    	    'new_item_name'     => __( 'Tambah Data Baru' ),
    	    'menu_name'         => __( 'Mata Pelajaran' ),
	    );   
	  
	    register_taxonomy('mapel',array('materi'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Pelajaran Umum',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_mapel',
                'edit_terms'    => 'edit_mapel',
                'delete_terms'  => 'delete_mapel',
                'assign_terms'  => 'assign_mapel',
            )
	  ));
	}
	
?>