<?php
    
	if ( get_theme_mod('opsi_editor') != "false" ) {
	    $showinrest = true;
	} else {
	    $showinrest = false;
    }
	
	register_post_type( 'video',		
	array(			
	    'menu_icon'       => 'dashicons-video-alt3',
		'labels'          => array(				
	    'name'                => __( 'Video' ),				
	    'singular_name'       => __( 'Video' ),        
	    'add_new'             => __( 'Tambah Video ?' ),	
	    'add_new_item'        => __( 'Tambah Video' ),	
	    'edit'                => __( 'Edit' ),	 
	    'edit_item'           => __( 'Edit Video' ),	
	    'new_item'            => __( 'Item Baru' ),	
	    'view'                => __( 'Lihat Video' ),	
	    'view_item'           => __( 'Lihat Item' ),	
	    'search_items'        => __( 'Cari Item' ),	
	    'not_found'           => __( 'Tidak Ada Video Ditemukan' ),	
	    'not_found_in_trash'  => __( 'Tidak Ada Video di Folder Trash' ),	
	    'parent'              => __( 'Parent Super Duper' ),
        'featured_image'      => __( 'Gambar 600 x 400' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => $showinrest,
			'capabilities' => array(
                'edit_post'                 => 'edit_vidio',
				'edit_posts'                => 'edit_vidios',
                'edit_others_posts'         => 'edit_other_vidios',
				'edit_private_posts'        => 'edit_private_vidios',
				'edit_published_posts'      => 'edit_published_vidios',
				'read_post'                 => 'read_vidio',
				'read_private_posts'        => 'read_private_vidios',
				'publish_posts'             => 'publish_vidios',
				'delete_post'               => 'delete_vidio',
                'delete_posts'              => 'delete_vidios',
                'delete_private_posts'      => 'delete_private_vidios',
				'delete_others_posts'       => 'delete_others_vidios',
                'delete_published_posts'    => 'delete_published_vidios',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'vid', 1);
	
	function vid() {
	    add_meta_box('sch_vid', 'Video Youtube', 'sch_vid', 'video', 'side', 'default');
	}

	function sch_vid() {
	    global $post;
	    echo '<input type="hidden" name="video_noncename" id="video_noncename" value="' .
	    wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

	    $vidembed = get_post_meta($post->ID, '_vidembed', true);
	    ?>
		
		<div class="press_metabox">
		
	        <label><?php echo __( 'Untuk Memudahkan Penambahan Video, Gunakan Embed Video Dari Youtube, Cukup Masukan ID Video', 'prestasi' ); ?></label>
			<input type="text" name="_vidembed" placeholder="<?php echo __( 'Masukan ID Saja, Bukan Link' ); ?>" value="<?php echo esc_attr( $vidembed ); ?>" class="widefat" />
			
		</div>
	<?php }

	function vid_meta($post_id, $post) {
	    if ( ! isset( $_POST['video_noncename'] ) || !wp_verify_nonce( $_POST['video_noncename'], plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }

	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
			
	    $events_meta['_vidembed'] = sanitize_text_field( $_POST['_vidembed'] );

	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key);
	    }

	}

	add_action('save_post', 'vid_meta', 1, 2); 
?>