<?php 
get_header();

if (have_posts()):
	while (have_posts()): the_post(); 
	    global $post;
		$materi_soal = get_post_meta($post->ID, 'materi_soal', true);
		$matdate = get_post_meta($post->ID, 'matdate', true);
	    $mattime = get_post_meta($post->ID, 'mattime', true);
		$showdate = get_post_meta($post->ID, 'showdate', true);
	    $showtime = get_post_meta($post->ID, 'showtime', true);
		$datetime = strtotime($matdate.' '.$mattime);
		$opentime = strtotime($showdate.' '.$showtime);
		$dateday = strtotime(date_i18n('d-m-Y H:i:s'));
		$onlydate = $datetime-$dateday;
		$opendate = $opentime-$dateday;
	?>
		
	<div class="press_page">
	    <div class="bread_in">
	        <?php // Top before content
		        the_title( '<h1 class="press_heading">', '</h1>' ); 
		        dimox_breadcrumbs(); 
	        ?>
        </div>
    </div>
		
	<section id="listing" class="clear">
	    <div class="press_container">
		    <div class="materi_outer clear">
				
				<div class="press_login clear">
				    <div class="login_in">
				        <?php if (is_user_logged_in()) { ?>
					        <div class="log_open">
							    <?php _e('Saat Ini Anda Sedang Dalam Posisi Login dan Dapat Melihat Konten Materi'); ?>
							</div>
					        <div class="log_close">
					        	<a class="login_button" href="<?php echo admin_url().'profile.php'; ?>"><?php _e('Profile'); ?></a>
						    	<a class="logout_button" href="<?php echo wp_logout_url( home_url() ); ?>"><?php _e('Keluar'); ?></a>
							</div>
							<?php
							    $user = wp_get_current_user();
								if ( in_array( 'siswa', (array) $user->roles ) ) { 
								?>
								    <div class="log_user">
									    <div class="log_photo">
										    <img src="<?php echo esc_url( $user->user_meta_image );?>" />
										</div>
										<div class="log_name"><?php echo esc_html( $user->display_name ); ?></div>
										<div class="log_name"><i class="fa fa-envelope-o"></i><br/><?php echo esc_html( $user->user_email ); ?></div>
									</div>
								<?php
								}
						} else { ?>
						    <div class="log_open">
							    <?php _e('Untuk Bisa Mengakses Konten Materi dan Tugas, Silahkan Login Terlebih Dahulu.'); ?>
							</div>
				            <?php get_template_part('ajax-auth'); 
						} ?>
					</div>
				</div>
	
		        <div class="press_kelas clear">
				    <div class="oc_class"><span></span></div>
		            <div class="kelas_cat clear">
				    	<div class="kelas_head">
						    <a class="to_materi" href="<?php echo get_post_type_archive_link( 'materi' ); ?>"><?php echo __('Materi Kelas', 'prestasi'); ?></a>
						</div>
						
			    		<?php 
					    	$taxonomy = 'tugas';
							$args =  array(
							    'hide_empty' => true,
								'orderby'    => 'name',
								'order'      => 'ASC'
							);
							$terms = get_terms( $taxonomy , $args );
							foreach( $terms as $term ) {
								$term_link = get_term_link( $term, 'tugas');
								echo '<div class="tugas_term"><a href="' . $term_link . '">'. $term->name . ' <span class="mat_count">' . $term->count . '</span></a></div>';
							}
						?>
						
					</div>
				</div>
				
				<div class="press_materi clear">
				<?php if ( $onlydate < 0 ) { ?>
				    <?php if ( $opendate < 0 ) { ?>
					    
					    <?php if (is_user_logged_in()) { ?> 
						<div class="materi_box">
						    <div class="press_article">
							    <?php the_content(); ?>
							</div>
							
							<div class="soal_tab">
							    <h3><?php echo __( 'Soal Pertanyaan', 'prestasi' ); ?></h3>
								<table>
								    <?php 
									    if (is_array($materi_soal)) {
											$soalcount = 0;
											foreach ( $materi_soal as $presssoal ) { 
											    $soalcount++;
											?>
							                    <tr>
								                    <td class="ask" colspan="4"><?php echo esc_html( $soalcount ).'. '; ?><?php echo esc_html( $presssoal['question'] ); ?></td>
												</tr>
												<tr>
								                    <td class="answer">A. <?php echo esc_html( $presssoal['answer1'] ); ?></td>
													<td class="answer">B. <?php echo esc_html( $presssoal['answer2'] ); ?></td>
													<td class="answer">C. <?php echo esc_html( $presssoal['answer3'] ); ?></td>
													<td class="answer">D. <?php echo esc_html( $presssoal['answer4'] ); ?></td>
							                    </tr>
											<?php 
											} 
										} else { 
										    ?>
											    <tr><td><?php echo __( 'Belum Ada Soal Ditambahkan', 'prestasi' ); ?></td></tr>
											<?php 
										} 
									?>
						    	</table>
							</div>
						</div>
						<?php } else { ?>
						<div class="materi_box">
						    <div class="close_materi">
							    <?php _e('Silahkan Login Untuk Dapat Mengakses Konten Materi'); ?>
							    <h3><?php the_title(); ?></h3>
							</div>
						</div>
						<?php } ?>
					<?php } else { ?>
					    <script>
						    var countDownDate = new Date("<?php echo $showdate; ?> <?php echo $showtime; ?>").getTime();
							var x = setInterval(function() {
								var now = new Date().getTime();
								var distance = countDownDate - now;
								
								var days = Math.floor(distance / (1000 * 60 * 60 * 24));
								var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
								var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
								var seconds = Math.floor((distance % (1000 * 60)) / 1000);
								
								document.getElementById("clock").innerHTML = "DIBUKA : " + days + " Hari + " + hours + ":" + minutes + ":" + seconds + "";
								
								if (distance < 0) {
									clearInterval(x);
									document.getElementById("clock").innerHTML = "<span>MATERI DIBUKA</span>";
									location.reload(); 
								}
							}, 1000);
						</script>
						<div id="clock"></div>
				        <div class="materi_box">
				        	<div class="close_materi">
						    	<?php _e('Mohon Maaf, Waktu Untuk Melihat Materi Sudah Habis'); ?>
						    	<h3><?php the_title(); ?></h3>
						    	<?php _e('Konten Ini Akan Bisa Dilihat Lagi Pada Tanggal : '); echo '<span>'. esc_html( date_i18n('j M Y', strtotime( $showdate  ) ) ).' '. esc_html( $showtime ).'</span>'; ?>
						    	<?php echo esc_html( $opentime ); ?>
					    	</div>
				    	</div>
					<?php } ?>
				<?php } else { ?>
				    <div class="materi_box">
					    <script>
						    var countDownDate = new Date("<?php echo $matdate; ?> <?php echo $mattime; ?>").getTime();
							var x = setInterval(function() {
								var now = new Date().getTime();
								var distance = countDownDate - now;
								
								var days = Math.floor(distance / (1000 * 60 * 60 * 24));
								var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
								var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
								var seconds = Math.floor((distance % (1000 * 60)) / 1000);
								
								document.getElementById("clock").innerHTML = "SISA : " + days + " Hari + " + hours + ":" + minutes + ":" + seconds + "";
								
								if (distance < 0) {
									clearInterval(x);
									document.getElementById("clock").innerHTML = "<span>WAKTU HABIS</span>";
									location.reload(); 
								}
							}, 1000);
						</script>
						<div id="clock"></div>
				    	<?php if (is_user_logged_in()) { ?> 
						    <div class="press_article">
							    <?php the_content(); ?>
							</div>
							
							<div class="soal_tab">
							    <h3><?php echo __( 'Soal Pertanyaan', 'prestasi' ); ?></h3>
								<table>
								    <?php 
									    if (is_array($materi_soal)) {
											$soalcount = 0;
											foreach ( $materi_soal as $presssoal ) { 
											    $soalcount++;
											?>
							                    <tr>
								                    <td class="ask" colspan="4"><?php echo esc_html( $soalcount ).'. '; ?><?php echo esc_html( $presssoal['question'] ); ?></td>
												</tr>
												<tr>
								                    <td class="answer">A. <?php echo esc_html( $presssoal['answer1'] ); ?></td>
													<td class="answer">B. <?php echo esc_html( $presssoal['answer2'] ); ?></td>
													<td class="answer">C. <?php echo esc_html( $presssoal['answer3'] ); ?></td>
													<td class="answer">D. <?php echo esc_html( $presssoal['answer4'] ); ?></td>
							                    </tr>
											<?php 
											} 
										} else { 
										    ?>
											    <tr><td><?php echo __( 'Belum Ada Soal Ditambahkan', 'prestasi' ); ?></td></tr>
											<?php 
										} 
									?>
						    	</table>
							</div>
						<?php } else { ?>
						    <div class="close_materi">
							    <?php _e('Silahkan Login Untuk Dapat Mengakses Konten Materi'); ?>
							    <h3><?php the_title(); ?></h3>
							</div>
						<?php } ?>
					</div>
				<?php } ?>
				</div>
		
			</div>
		</section>
		
	<?php 
	endwhile; 
endif; 

get_footer(); 
?>