<?php
class RecentBlog extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentblog',
			esc_html__( 'Prestasi : Blog Guru', 'prestasi' ),
			array( 'description' => esc_html__( 'Widget Ini Digunakan Untuk Menampilkan Pos Blog Guru', 'prestasi' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Blog Guru' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$blog_guru = ( ! empty( $instance['blog_guru'] ) ) ? absint( $instance['blog_guru'] ) : 3;
		if ( ! $blog_guru ) {
			$blog_guru = 3;
		}
		
		$q_args = array( 
			'post_type' => 'blog', 
			'numberposts' => $blog_guru,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
		?>
        <div class="post_widget clear">
	    	<div class="widget_thumb">
		        <?php 
				    if (has_post_thumbnail()) {
			            the_post_thumbnail('small');
		            }
		        ?>
		    </div>
		    <div class="post_wadd">
			    <span class="post_wplus"><?php echo __( 'Oleh : ', 'prestasi'); ?><?php the_author(); ?></span>
		        <div class="post_wtitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
		    </div>
        </div>
	<?php	endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['blog_guru'] = sanitize_text_field( $new_instance['blog_guru'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : 'Blog Guru';
		$blog_guru     = isset( $instance['blog_guru'] ) ? esc_attr( $instance['blog_guru'] ) : 10; ?>
		<p><?php _e('Widget Ini Digunakan Untuk Menampilkan Daftar Blog Guru Terbaru di Sidebar'); ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title :' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'blog_guru' ); ?>"><?php _e( 'Jumlah Pos :' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'blog_guru' ); ?>" name="<?php echo $this->get_field_name( 'blog_guru' ); ?>" type="number" value="<?php echo $blog_guru; ?>" /></p>

    <?php
	}
}