<?php
class RecentPengumuman extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentpengumuman',
			esc_html__( 'Prestasi : Pengumuman', 'prestasi' ),
			array( 'description' => esc_html__( 'Widget Ini Digunakan Untuk Menampilkan Post Pengumuman', 'prestasi' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Pengumuman' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$press_peng = ( ! empty( $instance['press_peng'] ) ) ? absint( $instance['press_peng'] ) : 3;
		if ( ! $press_peng ) {
			$press_peng = 3;
		}
		
		$q_args = array( 
			'post_type' => 'pengumuman', 
			'numberposts' => $press_peng,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
			$tanggalan = get_post_meta($post->ID, '_tevent', true);
		$minus = strtotime(get_post_meta($post->ID, '_tevent', true));
		$jam = get_post_meta($post->ID, '_jam', true);
		
		?>
		<div class="post_widget clear">
			<span class="post_wplus"><?php printf(__('Diterbitkan : <span class="post-date">%s</span>', 'prestasi'), get_the_date()); ?></span>
		    <div class="post_wtitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
		    <div class="post_wplus"><?php if (function_exists('smart_excerpt')) smart_excerpt(get_the_excerpt(), 15); ?></div>
		</div> 
	<?php	endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['press_peng'] = sanitize_text_field( $new_instance['press_peng'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : 'Pengumuman';
		$press_peng     = isset( $instance['press_peng'] ) ? esc_attr( $instance['press_peng'] ) : 3; ?>
		<p><?php _e( 'Widget Ini Digunakan Untuk Menampilkan Daftar Pengumuman Terbaru di Sidebar'); ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title :' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'press_peng' ); ?>"><?php _e( 'Jumlah Pos :' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'press_peng' ); ?>" name="<?php echo $this->get_field_name( 'press_peng' ); ?>" type="number" value="<?php echo $press_peng; ?>" /></p>

    <?php
	}
}