<?php
class SchoolInfo extends WP_Widget {
	function __construct() {
		parent::__construct(
			'schoolmaps',
			esc_html__( 'Prestasi : Info Sekolah', 'prestasi' ),
			array( 'description' => esc_html__( 'Widget Ini Digunakan Untuk Menampilkan Maps Sekolah', 'prestasi' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Maps Sekolah' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		?>
		    <div class="widget_sekolah clear">
			    <h4 class="nama_sekolah"><?php prestasi_nama_sekolah(); ?></h4>
				<div class="widget_contact clear">
				    <div class="wid_icon">
			        	<i class="fa fa-info"></i> 
					</div>
					<div class="wid_num">
				    	<?php echo __('NSPN :', 'prestasi'); ?> <span class="nspn"><?php prestasi_nspn(); ?></span>
					</div>
				</div>
				<div class="widget_contact clear">
				    <div class="wid_icon">
			        	<i class="fa fa-map-marker"></i> 
					</div>
					<div class="address"><?php prestasi_address(); ?></div>
				</div>
				<div class="widget_contact clear">
				    <div class="wid_icon">
			        	<i class="fa fa-volume-control-phone"></i> 
					</div>
					<div class="wid_num">
					    <span class="number"><?php prestasi_school_number(); ?></span>
					</div>
			    </div>
			</div>
    	<?php	
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : 'Maps Sekolah'; ?>
		<p><?php _e( 'Widget Ini Digunakan Untuk Menampilkan Daftar Maps Sekolah di Sidebar' ); ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title :' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
	
    <?php
	}
}